package objets;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

public class Arbre implements Objet {
	private float grandeur;
	private byte decalage;

	public Arbre() {
		grandeur = (float) (0.8+Math.random()/1.5);
		decalage = (byte) (50-Math.random()*100);
	}
	
	public void dessine(Graphics g, int x, int y, double taille) {
		int t = (int) (taille*grandeur);
		Graphics2D g2d = (Graphics2D) g;
		
		//tronc
		g2d.setPaint(new GradientPaint(new Point(x,y), new Color(50,10,0), new Point(x+t/10+1,y), new Color(120,60,0), true));
		g.fillRect(x, y-t+t/6, t/6+1, t);
		g.fillOval(x, y+t/8, t/6+1, t/12+1);
		
		//feuilles
		Point p = new Point(x+(t/6+1)/2, y-t);
		g2d.setPaint(new GradientPaint(p, new Color(50,110+decalage,0), new Point(p.x+t/2, p.y), new Color(0,50+decalage,0), true));
		g.fillOval(p.x, p.y, t/3, t/2);
		g.fillOval(p.x-t/3, p.y+t/6, t/3, t/2);
		g.fillOval(p.x-t/4, p.y-t/3, t/2, t);
	}

	public void reduit(int moins) {
		grandeur-=(double)moins/10;
	}

	public boolean estArbre() {
		return true;
	}

	public float getTaille() {
		return grandeur;
	}


}
