package panneaux;

import io.Images;
import io.Langue;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

import base.Fenetre;
import elements.Coord;
import elements.Jouer;

public class Jeu extends JPanel implements KeyListener, Runnable {
	private final int taille = 80;
	private static final long serialVersionUID = 1L;
	private Map map = new Map(taille, taille);
	private boolean g,d,h,b;
	private Jouer jeu = new Jouer(100, new Coord(taille-18, 0));
	private Images img = new Images();
	private JLabel arbres = new JLabel(new ImageIcon(img.getArbre().getScaledInstance(50, 50, 0))),
			persos = new JLabel(new ImageIcon(img.getPerso().getScaledInstance(50, 70, 0))),
			haut = new JLabel(new ImageIcon(img.getHaut().getScaledInstance(100, 100, 0))),
			bas = new JLabel(new ImageIcon(img.getBas().getScaledInstance(100, 100, 0))),
			lisse = new JLabel(new ImageIcon(img.getLisse().getScaledInstance(100, 100, 0))),
			lumiere = new JLabel(new ImageIcon(img.getLumiere().getScaledInstance(100, 100, 0)));

	public Jeu(Fenetre fenetre) {
		setSize(100, 100);
		init(fenetre);
		initListener();
		map.placer(jeu.getMobiles());
		addKeyListener(this);
	}

	private void init(Fenetre fenetre) {
		map.setLayout(null);
		//compteur d'arbres
		arbres.setBounds(10, -10, 150, 100);
		arbres.setFont(new Font(arbres.getFont().getName(), Font.BOLD, 40));
		arbres.setForeground(Color.WHITE);
		arbres.setToolTipText(Langue.getTexte(3));
		
		//compteur de persos
		persos.setBounds(fenetre.getSize().width-180, -10, 150, 100);
		persos.setFont(new Font(arbres.getFont().getName(), Font.BOLD, 40));
		persos.setForeground(Color.WHITE);
		persos.setToolTipText(Langue.getTexte(4));
		
		//boutons
		haut.setBounds(20, fenetre.getSize().height-170, 100, 100);
		bas.setBounds(140, fenetre.getSize().height-170, 100, 100);
		lisse.setBounds(260, fenetre.getSize().height-170, 100, 100);
		lumiere.setBounds(haut.getBounds());
		haut.setToolTipText(Langue.getTexte(0));
		bas.setToolTipText(Langue.getTexte(1));
		lisse.setToolTipText(Langue.getTexte(2));
		
		//map
		map.add(arbres);
		map.add(persos);
		map.add(haut);
		map.add(bas);
		map.add(lisse);
		map.add(lumiere);
		map.setBounds(0, 0, getSize().width, getSize().height);
		
		setLayout(new GridLayout(1,1));
		add(map);
	}
	
	//boucle de jeu
	public void run() {
		int nbrarbres = map.getNombreArbres();
		while(nbrarbres>0) {
			routine(nbrarbres);
			nbrarbres = map.getNombreArbres();
			map.repaint();
			try {Thread.sleep(100);} catch (InterruptedException e) {e.printStackTrace();}
		}
		arbres.setBounds(0, -10, 250, 100);
		arbres.setFont(new Font(arbres.getFont().getName(), Font.ITALIC, 20));
		arbres.setText(Langue.getTexte(-1));
	}
	
	private void routine(int nbrarbres) {
		if(Math.random()<0.05) {
			map.agrandirVille(0.01);
			jeu.spawn(1);
		}
		jeu.joue(map.getMap());
		map.placer(jeu.getMobiles());
		arbres.setText(String.valueOf(nbrarbres));
		persos.setText(String.valueOf(jeu.getMobiles().size()));
	}
	
	
	//listeners
	private void initListener() {
		haut.addMouseListener(new MouseListener() {
			public void mouseReleased(MouseEvent arg0) {}
			public void mouseClicked(MouseEvent arg0) {}
			public void mouseExited(MouseEvent arg0) {}
			public void mouseEntered(MouseEvent arg0) {}
			public void mousePressed(MouseEvent arg0) {
				map.setOutil(0);
				lumiere.setBounds(haut.getBounds());
			}
		});
		bas.addMouseListener(new MouseListener() {
			public void mouseReleased(MouseEvent arg0) {}
			public void mouseClicked(MouseEvent arg0) {}
			public void mouseExited(MouseEvent arg0) {}
			public void mouseEntered(MouseEvent arg0) {}
			public void mousePressed(MouseEvent arg0) {
				map.setOutil(1);
				lumiere.setBounds(bas.getBounds());
			}
		});
		lisse.addMouseListener(new MouseListener() {
			public void mouseReleased(MouseEvent arg0) {}
			public void mouseClicked(MouseEvent arg0) {}
			public void mouseExited(MouseEvent arg0) {}
			public void mouseEntered(MouseEvent arg0) {}
			public void mousePressed(MouseEvent arg0) {
				map.setOutil(2);
				lumiere.setBounds(lisse.getBounds());
			}
		});
	}
	
	@Override
	public void keyPressed(KeyEvent e) {
		switch (e.getKeyCode()) {
		case KeyEvent.VK_Z :
		case KeyEvent.VK_UP:
			h=true;
			break;
		case KeyEvent.VK_S :
		case KeyEvent.VK_DOWN:
			b=true;
			break;
		case KeyEvent.VK_D :
		case KeyEvent.VK_RIGHT:
			d=true;
			break;
		case KeyEvent.VK_Q :
		case KeyEvent.VK_LEFT:
			g=true;
			break;
		}
		if(h) map.evenementClavier('h');
		if(b) map.evenementClavier('b');
		if(g) map.evenementClavier('g');
		if(d) map.evenementClavier('d');
	}

	@Override
	public void keyReleased(KeyEvent e) {
		switch (e.getKeyCode()) {
		case KeyEvent.VK_Z :
		case KeyEvent.VK_UP:
			h=false;
			break;
		case KeyEvent.VK_S :
		case KeyEvent.VK_DOWN:
			b=false;
			break;
		case KeyEvent.VK_D :
		case KeyEvent.VK_RIGHT:
			d=false;
			break;
		case KeyEvent.VK_Q :
		case KeyEvent.VK_LEFT:
			g=false;
			break;
		}
	}

	@Override
	public void keyTyped(KeyEvent e) {}

}
