package panneaux;

import io.Son;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

import constructions.Immeuble;
import constructions.Ligne;

import mobiles.Mobile;
import objets.Arbre;
import objets.Rocher;
import elements.Case;
import elements.Coord;

public class Map extends JPanel implements MouseWheelListener, MouseInputListener {
	private static final long serialVersionUID = 1L;
	private int outil;
	private Case[][] map;
	private int largeur, longueur, click, dx, dy, dx0, dy0, posX, posY;
	private double pas=0.5, angle=0.2, angle0=0.5, taille;
	private Son son = new Son();
	private Case[] interdits;
	private ArrayList<Coord> mobiles = new ArrayList<Coord>(100);

	public Map(int largeur, int longueur) {
		this.largeur = largeur;
		this.longueur = longueur;
		taille = Toolkit.getDefaultToolkit().getScreenSize().getWidth()/(largeur+1);
		map = new Case[largeur][longueur];
		init();
		dx = (int) ((Toolkit.getDefaultToolkit().getScreenSize().width-(largeur+1)*taille)/2);
		dy = 10;
		setBackground(Color.BLACK);
		addMouseListener(this);
		addMouseMotionListener(this);
		addMouseWheelListener(this);
		terrainAleatoire();
	}

	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		g.setFont(new Font(g.getFont().getName(), g.getFont().getStyle(), (int) (taille/6)));
		if(angle<=0)
			for(int i=0 ; i<map[0].length ; i++) {
				for(int ii=0 ; ii<map.length ; ii++) {
					map[ii][i].dessine(g, taille, dx+dx0, dy+dy0, (int) (angle*taille), angle0);
				}
			}
		else 
			for(int i=0 ; i<map[0].length ; i++) {
				for(int ii=map.length-1 ; ii>=0 ; ii--) {
					map[ii][i].dessine(g, taille, dx+dx0, dy+dy0, (int) (angle*taille), angle0);
				}
			}
		dessineBords(g);
	}

	public void setOutil(int outil) {
		this.outil=outil;
	}

	public void placer(ArrayList<Mobile> liste) {
		for(Coord c : mobiles) map[c.getX()][c.getY()].effacer();
		for(Mobile m : liste) {
			map[m.getX()][m.getY()].addMobile(m);
			mobiles.add(new Coord(m.getX(),m.getY()));
		}
	}

	public Case[][] getMap() {
		return map;
	}

	public int getNombreArbres() {
		int n=0;
		for(int i=0 ; i<map[0].length ; i++) {
			for(int ii=0 ; ii<map.length ; ii++) {
				n+=map[ii][i].getNombreArbres();
			}
		}
		return n;
	}

	private void terrainAleatoire() {
		reliefAleatoire(0.2,0.1);
		foretsAleatoires(50, 500);
		rochersAleatoires(0.01);
		initCamp(15);
		initConstructions((byte) 15);
	}

	public void agrandirVille(double taux) {
		int i = (int) (Math.random()*interdits.length);
		if(interdits[i].sansConstruction() && !interdits[i].estRoute()) { 
			interdits[i].setConstruction(new Immeuble((byte)(1)));
		} 
		else interdits[i].agrandirConstruction(1);
	}

	private void initConstructions(byte longueur) {
		byte[] teinte = {-88,-120,-88};
		for(int i=0; i<longueur*longueur-longueur ; i++) {
			if((i-1)%longueur!=0) if(Math.random()<0.02) interdits[i].setConstruction(new Immeuble((byte)(1)));
		}
		int a=0;
		boolean draw = true;
		for(int i=(int) (Math.random()*(longueur-1)) ; i<longueur*longueur ; i++) {
			interdits[i].setTeinte(teinte);
			interdits[i].setConstruction(null);
			interdits[i].setRoute(true);
			a++;
			if(a==2) {
				if(draw) {
					interdits[i].setConstruction(new Ligne());
					applatir(interdits[i], 0.2f);
				}
				draw=!draw;
			}
			if(a%3==0) {
				i+= longueur-3;
				a=0;
			}
		}

	}

	private void initCamp(int cote) {
		interdits = new Case[cote*cote];
		int n=0;
		for(int i=map.length-1 ; i>=map.length-cote ; i--) {
			for(int ii=0 ; ii<cote ; ii++) {
				if(i==map.length-cote || ii==cote-1) applatir(map[i][ii], -0.5f);
				else applatir(map[i][ii], 0);
				map[i][ii].vider();
				map[i][ii].setTeinte(new byte[] {20,-20,40});
				interdits[n++] = map[i][ii];
			}
		}
	}

	private void rochersAleatoires(double taux) {
		for(int i=1 ; i<map.length-1 ; i++) {
			for(int ii=1 ; ii<map[0].length-1 ; ii++) {
				if(Math.random()<taux/4) map[i][ii].addObjet(new Rocher(), (int) (Math.random()*4));
			}
		}
	}

	private void reliefAleatoire(double relief, double tauxArbres) {
		for(int i=0 ; i<map.length ; i++) {
			for(int ii=0 ; ii<map[0].length ; ii++) {
				incrAltitude(map[i][ii], relief-2*Math.random()*relief);
			}
		}
		for(int n=0 ; n<10 ; n++) {
			int x=(int) (Math.random()*(largeur-1));
			int y=(int) (Math.random()*(longueur-1));
			for(Case c : getAdjacents(map[x][y], 15)) 
				if(Math.random()<0.25) incrAltitude(c, 1);
		}
	}

	private void foretsAleatoires(int forets, int nombre) {
		for(int n=0 ; n<forets ; n++) {
			int x=(int) (Math.random()*(largeur-2));
			int y=(int) (Math.random()*(longueur-2));
			for(Case c : getAdjacents(map[x][y], nombre)) 
				for(int coin : new int[]{0,1,2,3}) if(Math.random()<0.01) c.addObjet(new Arbre(), coin);
		}
	}

	private ArrayList<Case> getAdjacents(Case initiale, int nombre) {
		ArrayList<Case> adjacents = new ArrayList<Case>(nombre);
		adjacents.add(initiale);
		for(int i=0 ; i<adjacents.size() ; i++) {
			Case c = adjacents.get(i);
			if(c.getX()+1<largeur) adjacents.add(map[c.getX()+1][c.getY()]);
			if(c.getX()-1>0) adjacents.add(map[c.getX()-1][c.getY()]);
			if(c.getY()+1<longueur) adjacents.add(map[c.getX()][c.getY()+1]);
			if(c.getY()-1>0) adjacents.add(map[c.getX()][c.getY()-1]);
			if(adjacents.size()>=nombre) break;
		}
		return adjacents;
	}

	private void init() {
		for(int i=0 ; i<map.length ; i++) {
			for(int ii=0 ; ii<map[0].length ; ii++) {
				map[i][ii] = new Case(i, ii, largeur, longueur);
			}
		}
	}

	private Case getTuileEn(int x, int y, boolean hautEnBas) {
		if(hautEnBas) for(int i=0 ; i<longueur ; i++) {
			for(int ii=0 ; ii<largeur ; ii++) {
				if(map[ii][i].getTuile(taille, dx+dx0, dy+dy0, (int) (angle*taille), angle0).contains(new Point(x, y))) {
					if((i!=0 && i!=largeur-1) || (ii!=0 && ii!=longueur-1)) return map[ii][i];
				}
			}
		}
		else for(int i=longueur-1 ; i>=0 ; i--) {
			for(int ii=0 ; ii<largeur ; ii++) {
				if(map[ii][i].getTuile(taille, dx+dx0, dy+dy0, (int) (angle*taille), angle0).contains(new Point(x, y))) {
					return map[ii][i];
				}
			}
		}
		return null;
	}

	private void incrAltitude(Case c, double altitude) {
		for(int i : new int[] {0,1,2,3}) c.incrAltitude(i, altitude);
		Case[] adjacents = getAdjacents(c);
		int[][] sommets = getCoinsAdjacents(c);
		for(int i=0 ; i<adjacents.length ; i++) {
			for(int coin : sommets[i]) 
				if(adjacents[i]!=null) adjacents[i].incrAltitude(coin,altitude);
		}
	}

	private Case[] getAdjacents(Case c) {
		Case[] retour = new Case[8];
		Coord[] adjacents = new Coord[] {
				new Coord(c.getX()-1,c.getY()-1),
				new Coord(c.getX(),c.getY()-1),
				new Coord(c.getX()+1,c.getY()-1),
				new Coord(c.getX()-1,c.getY()),
				new Coord(c.getX()+1,c.getY()),
				new Coord(c.getX()-1,c.getY()+1),
				new Coord(c.getX(),c.getY()+1),
				new Coord(c.getX()+1,c.getY()+1)
		};
		for(int i=0 ; i<adjacents.length ; i++)  
			if(estcorrect(adjacents[i].getX(), adjacents[i].getY()))
				retour[i] = map[adjacents[i].getX()][adjacents[i].getY()];
			else retour[i] = null;
		return retour;
	}
	private int[][] getCoinsAdjacents(Case c) {
		int[][] adjacents = new int[][] {
				new int[] {2},
				new int[] {2,3},
				new int[] {3},
				new int[] {1,2},
				new int[] {0,3},
				new int[] {1},
				new int[] {0,1},
				new int[] {0}
		};
		return adjacents;
	}

	private boolean estcorrect(int x, int y) {
		return x>=0 && x<largeur && y>=0 && y<longueur;
	}

	public void applatir(Case c, float niveau) {
		c.setAltitude(new float[] {niveau,niveau,niveau,niveau});
		Case[] adjacents = getAdjacents(c);
		int[][] sommets = getCoinsAdjacents(c);
		for(int i=0 ; i<adjacents.length ; i++) {
			for(int coin : sommets[i]) 
				if(adjacents[i]!=null) adjacents[i].applatir(niveau, coin);
		}
	}

	//Listeners

	@Override
	public void mouseDragged(MouseEvent e) {
		Case concernee = getTuileEn(e.getX(), e.getY(), false);
		if(concernee!=null && estAutorise(concernee)) {
			switch(click) {
			case MouseEvent.BUTTON1 :
				byte plusOuMoins=-1;
				switch(outil) {
				case 0 :
					plusOuMoins=1;
				case 1 :
					incrAltitude(concernee, pas*plusOuMoins);
					int zone = (int) (taille*taille);
					repaint(e.getX()-zone/2, e.getY()-zone/2, zone, (int)(zone*1.5));
					break;

				case 2 :
					applatir(concernee, 0);
					int zoneuh = (int) (taille*taille);
					repaint(e.getX()-zoneuh/2, e.getY()-zoneuh/2, zoneuh, (int)(zoneuh*1.5));
					break;
				}
				break;
			case MouseEvent.BUTTON3 :
				dx0 = e.getX()-posX;
				dy0 = e.getY()-posY;
				repaint();
				break;
			case MouseEvent.BUTTON2 :
				int distance = Math.abs((e.getX()-posX)+(e.getY()-posY));
				if(distance>5) if(Math.abs(e.getX()-posX)>Math.abs(e.getY()-posY)) {
					if(e.getX()-posX>=0) incrAngle((0.03*distance)/taille);
					else incrAngle(-(0.03*distance)/taille);
				}
				else {
					if(e.getY()-posY>=0) angle0+=(0.01*distance)/taille; 
					else angle0-=(0.01*distance)/taille;
					if(angle0<0.1) angle0=0.1;
					if(angle0>0.5) angle0=0.5;
				}
				posX=e.getX();
				posY=e.getY();
				repaint();
				break;
			}
		}
	}

	@Override
	public void mouseMoved(MouseEvent e) {}

	@Override
	public void mouseClicked(MouseEvent e) {}

	@Override
	public void mouseEntered(MouseEvent e) {}

	@Override
	public void mouseExited(MouseEvent e) {}

	@Override
	public void mousePressed(MouseEvent e) {
		posX=e.getX()-dx0;
		posY=e.getY()-dy0;
		click = e.getButton();	
		if(click==MouseEvent.BUTTON1) son.terre();
		mouseDragged(e);
		repaint();
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		son.stopTerre();
		posX=e.getX();
		posY=e.getY();
	}

	@Override
	public void mouseWheelMoved(MouseWheelEvent e) {
		switch (e.getModifiersEx()) {
		case MouseEvent.CTRL_DOWN_MASK:
			incrAngle(-(double) e.getUnitsToScroll()/(taille*2));
			break;
		default:
			taille -= e.getUnitsToScroll();
			if(taille<5) {taille=5; break;}
			if(taille>100) {taille=100; break;}
			dx += e.getUnitsToScroll()*taille;
			dy += e.getUnitsToScroll()*taille/2;
			break;
		}
		repaint();
	}

	public void incrAngle(double ajout) {
		angle+= ajout;
		if(angle>1.5) {angle=1.5; return;}
		if(angle <-1.5) {angle=-1.5; return;}
	}

	public void evenementClavier(char dir) {
		int d=(int) taille;
		switch (dir) {
		case 'h':
			dy+=d;
			break;
		case 'b':
			dy-=d;
			break;
		case 'd':
			dx-=d;
			break;
		case 'g':
			dx+=d;
			break;
		}
		repaint();
	}

	private boolean estAutorise(Case c) {
		for(Case i : interdits) if(i.equals(c)) return false;
		return true;
	}

	private void dessineBords(Graphics g) {
		Graphics2D g2d = (Graphics2D) g;
		byte epaisseur=10;
		int[][] points;
		int i;

		//bord du bas
		points = new int[2][map.length*2+2];
		i=0;
		for(int x=0 ; x < map.length ; x++) {
			Polygon p = map[x][map[0].length-1].getTuile(taille, dx+dx0, dy+dy0, (int) (angle*taille), angle0);
			points[0][i] = p.xpoints[3];
			points[0][i+1] = p.xpoints[2];
			points[1][i] = p.ypoints[3];
			points[1][i+1] = p.ypoints[2];
			i+=2;
		}
		points[0][map.length*2] = points[0][map.length*2-1];
		points[1][map.length*2] = points[1][map.length*2-1]+(int)(epaisseur*taille);
		points[0][map.length*2+1] = points[0][0];
		points[1][map.length*2+1] = points[1][0]+(int)(epaisseur*taille);

		g2d.setPaint(new GradientPaint(new Point(points[0][0],points[1][0]), new Color(75,50,0), 
				new Point(points[0][map.length*2-1],points[1][map.length*2-1]), new Color(50,40,0)));
		g.fillPolygon(points[0], points[1], points[0].length);

		//cote
		points = new int[2][map[0].length*2+2];
		i=0;
		int x;
		byte d=0;
		if(angle>0) {x=0; d=1;}
		else x=map.length-1;
		for(int y=0 ; y < map[0].length ; y++) {
			Polygon p = map[x][y].getTuile(taille, dx+dx0, dy+dy0, (int) (angle*taille), angle0);
			points[0][i] = p.xpoints[1-d%2];
			points[0][i+1] = p.xpoints[2+d%2];
			points[1][i] = p.ypoints[1-d%2];
			points[1][i+1] = p.ypoints[2+d%2];
			i+=2;
		}
		points[0][map.length*2] = points[0][map.length*2-1];
		points[1][map.length*2] = points[1][map.length*2-1]+(int)(epaisseur*taille);
		points[0][map.length*2+1] = points[0][0];
		points[1][map.length*2+1] = points[1][0]+(int)(epaisseur*taille);

		g2d.setPaint(new GradientPaint(new Point(points[0][map.length*2+1],points[1][map.length*2+1]), new Color(20+d*40,30+d*30,0), 
				new Point(points[0][map.length],points[1][map.length]), new Color(50+d*60,20+d*30,0)));
		g.fillPolygon(points[0], points[1], points[0].length);
	}
}
