/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.base;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.base.Console;
import fr.utt.lo02.uno.io.reseau.client.SalleReseau;
import fr.utt.lo02.uno.io.reseau.serveur.Serveur;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.action.generateur.GenerateurActionConsole;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import fr.utt.lo02.uno.jeu.listener.JeuListener;
import fr.utt.lo02.uno.temps.Horloge;
import fr.utt.lo02.uno.ui.Fenetre;
import fr.utt.lo02.uno.ui.IconeTache;
import fr.utt.lo02.uno.ui.composant.ecran.EcranAccueil;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;

public class AdminJeu
implements JeuListener {
    private static final String[][] COMMANDES = new String[][]{{"prepare", "Cree une salle de jeu, pouvant accueillir le nombre de joueurs specifie", "[nombre]"}, {"add", "Ajoute un joueur, avec un nom", "[nom] [controle par joueur]"}, {"remove", "Supprime un joueur selon son rang", "[rang]"}, {"affiche", "Affiche les joueurs et les places disponibles"}, {"start", "Lance une nouvelle partie"}, {"host", "Heberge une salle de jeu en ligne", "[nom]"}, {"join", "Rejoint une partie en ligne, a l'adresse indiquee", "[nom joueur] [adresse]"}, {"fenetre", "Ouvre l'interface graphique de l'application"}};
    private final Horloge horloge = new Horloge();
    private Jeu jeu;
    private GenerateurActionConsole console;

    public boolean action(String action) {
        int i = 0;
        while (i < COMMANDES.length) {
            String[] args = action.split(" ");
            if (args.length > 0 && AdminJeu.getCommande(i).equalsIgnoreCase(args[0])) {
                this.action(i, args);
                return true;
            }
            ++i;
        }
        if (this.console != null) {
            this.console.action(action);
        }
        return false;
    }

    public void action(int id, String[] args) {
        block20: {
            try {
                if (id != 0 && id < 5 && this.jeu == null) {
                    Console.getInstance().affiche("Vous devez d'abord creer une salle : prepare [nombre]");
                    break block20;
                }
                switch (id) {
                    case 0: {
                        if (args.length > 1) {
                            this.jeu = new Jeu(Integer.valueOf(args[1]));
                        }
                        break;
                    }
                    case 1: {
                        Joueur j;
                        if (args.length < 3) {
                            j = new Joueur(TypeJoueur.ORDINATEUR, args.length < 2 ? "Sans nom" : args[1]);
                        } else {
                            if (this.console == null) {
                                this.console = new GenerateurActionConsole();
                            }
                            j = new Joueur(TypeJoueur.HUMAIN, args[1]);
                            j.addTourJoueurListener(this.console);
                        }
                        this.jeu.getListeJoueurs().ajoutJoueur(j);
                        break;
                    }
                    case 2: {
                        this.jeu.getListeJoueurs().retireJoueur(args.length < 2 ? 0 : Integer.valueOf(args[1]));
                        break;
                    }
                    case 3: {
                        int i = 0;
                        while (i < this.jeu.getListeJoueurs().getJoueurs().length) {
                            Joueur joueur = this.jeu.getListeJoueurs().getJoueurs()[i];
                            Console.getInstance().affiche(String.valueOf(i) + ") " + (joueur == null ? "(libre)" : joueur));
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        this.jeu.nouvellePartie();
                        this.horloge.lancer();
                        break;
                    }
                    case 5: {
                        new Serveur(new Salle()).lancer();
                        break;
                    }
                    case 6: {
                        SalleReseau r = new SalleReseau(args.length >= 2 ? args[1] : "Anonyme", args.length >= 3 ? args[2] : "127.0.0.1");
                        this.jeu = r.getJeu();
                        this.jeu.addJeuListener(this);
                        this.console = new GenerateurActionConsole();
                        break;
                    }
                    case 7: {
                        Console.getInstance().affiche("Lancement de l'interface graphique...");
                        try {
                            Configuration.charger();
                            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
                            IconeTache.getInstance();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        new Fenetre(new EcranAccueil());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getCommandes() {
        String s = "";
        int i = 0;
        while (i < COMMANDES.length) {
            s = String.valueOf(s) + AdminJeu.getCommande(i) + " " + AdminJeu.getArguments(i) + " : " + AdminJeu.getDescription(i) + "\n";
            ++i;
        }
        return s;
    }

    public static String getCommande(int id) {
        return COMMANDES[id][0];
    }

    public static String getArguments(int id) {
        return COMMANDES[id].length > 2 ? COMMANDES[id][2] : "";
    }

    public static String getDescription(int id) {
        return COMMANDES[id][1];
    }

    @Override
    public void nouvellePartie(Partie partie) {
        for (Joueur j : partie.getJoueurs().getListeJoueurs()) {
            if (j.getType() != TypeJoueur.HUMAIN) continue;
            j.addTourJoueurListener(this.console);
        }
    }

    @Override
    public void finPartie(Partie partie, ResultatPartie resultats) {
        for (Joueur joueur : partie.getJoueurs().getListeJoueurs()) {
            if (joueur.getType() != TypeJoueur.HUMAIN) continue;
            joueur.removeTourJoueurListener(this.console);
        }
        Console.getInstance().affiche(resultats.getGagnant() + " gagne la partie");
        for (Map.Entry entry : resultats.getPoints().entrySet()) {
            Console.getInstance().affiche(entry.getKey() + " : " + entry.getValue() + " points");
        }
        Console.getInstance().retourLigne();
    }

    @Override
    public void finJeu(List<ResultatPartie> resultats, Jeu jeu) {
        Console.getInstance().affiche(ResultatPartie.getGagnant(resultats) + " gagne le jeu !");
    }
}

