/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io;

import fr.utt.lo02.uno.io.interfaces.IOable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class IO
implements IOable {
    public static final byte VRAI = 0;
    public static final byte FAUX = 1;
    public static final byte LIMITE_BYTE_MAX = 127;
    public static final byte LIMITE_BYTE_MIN = -128;
    public static final int LIMITE_BYTE_POSITIF = 255;
    public static final int LIMITE_SHORT_MAX = 65535;
    public static final int LIMITE_3_BYTES = 0x7FFFFF;
    public static final int LIMITE_3_BYTES_POSITIF = 0xFFFFFF;
    public static final int LIMITE_SHORT_STRING = 255;
    public static final int LIMITE_STRING = 65535;
    private final List<Byte> buffer;
    private byte[] build;
    private int index;
    private boolean builded;

    public IO(byte ... bytes) {
        this.buffer = new ArrayList<Byte>();
        this.addBytes(bytes);
        this.build = bytes;
        this.builded = true;
    }

    public IO(IO io) {
        this.buffer = io.buffer;
        this.build = io.build;
        this.builded = io.builded;
    }

    public IO setIndex(int index) {
        this.index = index;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public IO addByte(byte b) {
        this.buffer.add(b);
        this.builded = false;
        return this;
    }

    public IO addByte(int b) {
        IO.check(b, -128, 127);
        return this.addByte((byte)b);
    }

    public IO addLong(String str) {
        return this.add(str.length()).addBytes(str.getBytes());
    }

    public IO add(int i) {
        return this.add((byte)(i >> 24)).add((byte)(i >> 16)).add((byte)(i >> 8)).add((byte)i);
    }

    public IO add(byte b) {
        return this.addByte(b);
    }

    public IO add(boolean b) {
        return this.add(b ? (byte)0 : 1);
    }

    public IO add(long l) {
        return this.addBytes(ByteBuffer.allocate(8).putLong(l).array());
    }

    public IO add(IOable io) {
        return this.addBytes(io.getBytes());
    }

    public IO addShort(String str) {
        return this.addBytePositif(str.length()).addBytes(str.getBytes());
    }

    public IO addShort(int i) {
        IO.check(i, 0, 65535);
        return this.add((byte)(i >> 8)).add((byte)i);
    }

    public IO add(String str) {
        return this.addShort(str.length()).addBytes(str.getBytes());
    }

    public IO addBytePositif(int b) {
        IO.check(b, 0, 255);
        return this.add((byte)(b - 127 - 1));
    }

    public IO addIntsPositif(int ... ints) {
        int[] nArray = ints;
        int n = ints.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.addShort(i);
            ++n2;
        }
        return this;
    }

    public IO addInts(int ... ints) {
        int[] nArray = ints;
        int n = ints.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.add(i);
            ++n2;
        }
        return this;
    }

    public IO addIntsPositifs(int ... ints) {
        int[] nArray = ints;
        int n = ints.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.addShort(i);
            ++n2;
        }
        return this;
    }

    public IO addShortsPositif(int ... ints) {
        int[] nArray = ints;
        int n = ints.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.addShort(i);
            ++n2;
        }
        return this;
    }

    public IO addStrings(String ... str) {
        String[] stringArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.add(s);
            ++n2;
        }
        return this;
    }

    public IO addShortStrings(String ... str) {
        String[] stringArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.addShort(s);
            ++n2;
        }
        return this;
    }

    public IO addBytes(byte ... b) {
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte bb = byArray[n2];
            this.add(bb);
            ++n2;
        }
        return this;
    }

    public IO addBytesPositif(int ... b) {
        int[] nArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.addBytePositif(i);
            ++n2;
        }
        return this;
    }

    public byte next() {
        return this.buffer.get(this.index++);
    }

    public int nextPositif() {
        return this.next() + 127 + 1;
    }

    public int nextInt() {
        return ByteBuffer.wrap(new byte[]{this.next(), this.next(), this.next(), this.next()}).getInt();
    }

    public long nextLong() {
        return ByteBuffer.wrap(new byte[]{this.next(), this.next(), this.next(), this.next(), this.next(), this.next(), this.next(), this.next()}).getLong();
    }

    public boolean nextBoolean() {
        return this.next() == 0;
    }

    public String nextStringLong() {
        byte[] b = new byte[this.nextInt()];
        int i = 0;
        while (i < b.length) {
            b[i] = this.next();
            ++i;
        }
        return new String(b);
    }

    public String nextShortString() {
        byte[] b = new byte[this.nextPositif()];
        int i = 0;
        while (i < b.length) {
            b[i] = this.next();
            ++i;
        }
        return new String(b);
    }

    public String nextString() {
        byte[] b = new byte[this.nextShortInt()];
        int i = 0;
        while (i < b.length) {
            b[i] = this.next();
            ++i;
        }
        return new String(b);
    }

    public int nextShortInt() {
        byte[] byArray = new byte[4];
        byArray[2] = this.next();
        byArray[3] = this.next();
        return ByteBuffer.wrap(byArray).getInt();
    }

    public int[] nextIntsPositifs(int nombre) {
        int[] i = new int[nombre];
        int j = 0;
        while (j < i.length) {
            i[j] = this.nextShortInt();
            ++j;
        }
        return i;
    }

    public int[] nextPositifs(int nombre) {
        int[] i = new int[nombre];
        int j = 0;
        while (j < i.length) {
            i[j] = this.nextPositif();
            ++j;
        }
        return i;
    }

    public void inserer(int index, byte b) {
        this.buffer.set(index, b);
    }

    public void inserer(int index, long l) {
        byte[] array = ByteBuffer.allocate(8).putLong(l).array();
        int i = 0;
        while (i < array.length) {
            this.inserer(index + i, array[i]);
            ++i;
        }
    }

    public boolean aByte() {
        return this.index + 1 <= this.buffer.size();
    }

    public boolean aPositif() {
        return this.aByte();
    }

    public boolean aBytes(int nombre) {
        return this.index + 1 * nombre <= this.buffer.size();
    }

    public boolean aBoolean() {
        return this.aByte();
    }

    public boolean aBooleans(int nombre) {
        return this.aBytes(nombre);
    }

    public boolean aShortInt() {
        return this.aBytes(2);
    }

    public boolean aInt() {
        return this.aBytes(4);
    }

    public boolean aLong() {
        return this.aBytes(8);
    }

    public boolean aInts(int nombre) {
        return this.aBytes(4 * nombre);
    }

    public boolean aStringLong() {
        if (!this.aInt()) {
            return false;
        }
        int tmp = this.index;
        boolean a = this.index + this.nextInt() <= this.buffer.size();
        this.setIndex(tmp);
        return a;
    }

    public boolean aShortString() {
        if (!this.aByte()) {
            return false;
        }
        int tmp = this.index;
        boolean a = this.index + this.nextPositif() <= this.buffer.size();
        this.setIndex(tmp);
        return a;
    }

    public boolean aString() {
        if (!this.aShortInt()) {
            return false;
        }
        int tmp = this.index;
        boolean a = this.index + this.nextShortInt() <= this.buffer.size();
        this.setIndex(tmp);
        return a;
    }

    public void build() {
        this.build = new byte[this.buffer.size()];
        int i = 0;
        while (i < this.build.length) {
            this.build[i] = this.buffer.get(i);
            ++i;
        }
        this.builded = true;
    }

    public int size() {
        return this.buffer.size();
    }

    public IO supprimer(int rang) {
        this.buffer.remove(rang);
        this.builded = false;
        return this;
    }

    public IO supprimer(int debut, int fin) {
        int i = debut;
        while (i < fin - debut) {
            this.supprimer(debut);
            ++i;
        }
        return this;
    }

    public IO inverser(int i1, int i2) {
        byte tmp = this.buffer.get(i1);
        this.buffer.set(i1, this.buffer.get(i2));
        this.buffer.set(i2, tmp);
        this.builded = false;
        return this;
    }

    public void passer(int nombre) {
        this.index += nombre;
    }

    public void vider() {
        this.buffer.clear();
        this.index = 0;
        this.builded = false;
    }

    public byte[] getBytesRestants() {
        return this.getBytesRestants(this.index, this.size() - 1);
    }

    public byte[] getBytesRestants(int debut, int fin) {
        byte[] b = new byte[fin - debut];
        int i = 0;
        while (i < b.length) {
            b[i] = this.buffer.get(debut + i);
            ++i;
        }
        return b;
    }

    @Override
    public byte[] getBytes() {
        if (!this.builded) {
            this.build();
        }
        return this.build;
    }

    public String toString() {
        return new String(this.getBytes());
    }

    private static void check(int valeur, int min, int max) {
        IO.checkMin(valeur, min);
        IO.checkMax(valeur, max);
    }

    private static void checkMax(int valeur, int max) {
        if (valeur > max) {
            throw new IllegalArgumentException("Valeur hors limite : " + valeur + " (max=" + max + ")");
        }
    }

    private static void checkMin(int valeur, int min) {
        if (valeur < min) {
            throw new IllegalArgumentException("Valeur hors limite : " + valeur + " (min=" + min + ")");
        }
    }

    public static byte[] getBytes(int i) {
        IO.check(i, 0, 0xFFFFFF);
        return new byte[]{(byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    public static int getInt(byte ... b) {
        if (b.length != 3) {
            throw new IllegalArgumentException("Cette methode necessite un tableau de dimension 3");
        }
        int i1 = b[0] << 16;
        int i2 = b[1] << 8;
        int i3 = b[2];
        return (i1 < 0 ? i1 + 0x1000000 : i1) + (i2 < 0 ? i2 + 65536 : i2) + (i3 < 0 ? i3 + 256 : i3);
    }
}

