/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io;

import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.CarteNumero;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.carte.TypeCarte;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class ImageCartes {
    private static final int NOMBRE_IMAGES = 16;
    private static final int LARGEUR = 285;
    private static final int HAUTEUR = 435;
    private static ImageCartes instance;
    private final BufferedImage[] images;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageCartes getInstance() {
        Class<Images> clazz = Images.class;
        synchronized (Images.class) {
            if (instance == null) {
                instance = new ImageCartes();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ImageCartes() {
        BufferedImage sprite = Images.getInstance().getImage("cartes.png");
        this.images = new BufferedImage[16];
        int i = 0;
        while (i < this.images.length) {
            this.images[i] = sprite.getSubimage(i % 4 * 285, i / 4 * 435, 285, 435);
            ++i;
        }
    }

    public BufferedImage getImage(TypeCarte type, int numero) {
        return this.images[ImageCartes.getRangImage(type, numero)];
    }

    public BufferedImage getImage(Carte carte) {
        return this.getImage(carte.getType(), carte.getType() == TypeCarte.NUMERO ? ((CarteNumero)carte).getNumero() : 0);
    }

    public void dessiner(Graphics g, int width, int height, Carte carte, boolean visible) {
        this.dessiner(g, 0, 0, width, height, carte, visible);
    }

    public void dessiner(Graphics g, int x, int y, int width, int height, Carte carte, boolean visible) {
        if (carte != null) {
            ImageCartes.dessiner(g, visible ? this.getImage(carte) : this.getImage(null, 0), x, y, width, height, carte.getCouleur());
        }
    }

    public static void dessiner(Graphics g, BufferedImage image, int x, int y, int width, int height, Couleur couleur) {
        g.setColor(couleur == null ? Color.BLACK : couleur.getColor());
        g.fillRoundRect(x + width / 75, y + height / 55, width - width / 33, height - height / 33, width / 5, height / 5);
        g.drawImage(image, x, y, width, height, null);
    }

    public static int getRangImage(TypeCarte type, int numero) {
        if (type != null) {
            switch (type) {
                case NUMERO: {
                    return numero;
                }
                case PLUS_DEUX: {
                    return 10;
                }
                case INVERSION: {
                    return 11;
                }
                case PASSE_TOUR: {
                    return 12;
                }
                case PLUS_QUATRE: {
                    return 13;
                }
                case JOKER: {
                    return 14;
                }
            }
        }
        return 15;
    }
}

