/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.Out;
import fr.utt.lo02.uno.io.exception.HorsLigneException;
import fr.utt.lo02.uno.io.exception.InvalideException;
import fr.utt.lo02.uno.io.interfaces.Lancable;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import fr.utt.lo02.uno.io.reseau.listeners.ReceiveListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public abstract class InOut
extends Out
implements Runnable,
Lancable {
    private InputStream input;
    private boolean run;

    public InOut() {
    }

    public InOut(InputStream reader, OutputStream writer) {
        super(writer);
        this.setOut(writer);
    }

    public abstract byte[] lire() throws IOException, InvalideException, HorsLigneException;

    public void setIn(InputStream input) {
        this.input = input;
    }

    public InputStream getIn() {
        return this.input;
    }

    public void addReceiveListener(ReceiveListener l) {
        this.addListener(ReceiveListener.class, l);
    }

    public void removeReceiveListener(ReceiveListener l) {
        this.removeListener(ReceiveListener.class, l);
    }

    public byte lireByte() throws IOException, HorsLigneException {
        int i = this.input.read();
        if (i == -1) {
            throw new HorsLigneException();
        }
        return (byte)i;
    }

    public int lireShortInt() throws IOException, HorsLigneException {
        return IO.getInt(this.lireByte(), this.lireByte(), this.lireByte());
    }

    public byte[] lire(int nbr) throws IOException, HorsLigneException {
        byte[] b = new byte[nbr];
        int i = 0;
        while (i < b.length) {
            b[i] = this.lireByte();
            ++i;
        }
        return b;
    }

    protected void notifyReceiveListener(TypePaquet type, IO in) {
        ReceiveListener[] receiveListenerArray = (ReceiveListener[])this.getListeners(ReceiveListener.class);
        int n = receiveListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReceiveListener l = receiveListenerArray[n2];
            in.setIndex(1);
            try {
                l.recu(type, in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public boolean isRunning() {
        return this.run;
    }

    @Override
    public void run() {
        while (this.isRunning()) {
            try {
                IO io = new IO(this.lire());
                this.notifyReceiveListener(TypePaquet.get(io.nextPositif()), io);
            }
            catch (SocketTimeoutException e) {
                this.fermer();
            }
            catch (SocketException e) {
                this.fermer();
            }
            catch (HorsLigneException e) {
                this.fermer();
            }
            catch (InvalideException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean lancer() {
        this.run = true;
        new Thread(this).start();
        return this.run;
    }

    @Override
    public boolean fermer() {
        if (super.fermer()) {
            try {
                this.input.close();
                this.run = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return !this.run;
    }
}

