/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau;

import fr.utt.lo02.uno.io.reseau.InOutCodeID;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class InOutReseau
extends InOutCodeID {
    private final Socket socket;

    public InOutReseau() throws IOException {
        this(InetAddress.getLocalHost());
    }

    public InOutReseau(InetAddress adresse) throws IOException {
        this(adresse, 9876);
    }

    public InOutReseau(InetAddress adresse, int port) throws IOException {
        this(new Socket(adresse, port));
    }

    public InOutReseau(Socket socket) throws IOException {
        this.socket = socket;
        this.setOut(socket.getOutputStream());
        this.setIn(socket.getInputStream());
    }

    public InetAddress getAdresse() {
        return this.socket.getInetAddress();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public boolean fermer() {
        if (super.fermer()) {
            try {
                this.socket.close();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

