/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.exception.InvalideException;
import fr.utt.lo02.uno.io.interfaces.Fermable;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import fr.utt.lo02.uno.io.reseau.listeners.ReceiveListener;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class SocketUDP
extends Listenable
implements Runnable,
Fermable {
    private static final int TAILLE = 100;
    private static final String ADRESSE = "224.0.0.23";
    private static final int PORT = 6789;
    private final MulticastSocket socket = new MulticastSocket(6789);
    private InetAddress adresse;

    public void lancer() throws IOException {
        this.adresse = InetAddress.getByName(ADRESSE);
        this.socket.joinGroup(this.adresse);
        new Thread(this).start();
    }

    public void recu(IO io) throws InvalideException {
        this.recu(TypePaquet.get(io.nextPositif()), io);
    }

    public void recu(TypePaquet type, IO io) {
        ReceiveListener[] receiveListenerArray = (ReceiveListener[])this.getListeners(ReceiveListener.class);
        int n = receiveListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReceiveListener l = receiveListenerArray[n2];
            io.setIndex(1);
            l.recu(type, io);
            ++n2;
        }
    }

    public void envoyer(IO io) throws IOException {
        this.socket.send(new DatagramPacket(io.getBytes(), io.size(), this.adresse, 6789));
    }

    @Override
    public boolean fermer() {
        try {
            this.socket.close();
            return true;
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            try {
                DatagramPacket paquet = new DatagramPacket(new byte[100], 100);
                this.socket.receive(paquet);
                this.recu(new IO(paquet.getData()));
            }
            catch (SocketException paquet) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

