/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau.client;

import fr.utt.lo02.uno.base.Outil;
import fr.utt.lo02.uno.io.exception.AnnulationException;
import fr.utt.lo02.uno.io.reseau.Paquet;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import fr.utt.lo02.uno.io.reseau.client.Client;
import java.net.InetAddress;

public class Connexion
extends Thread {
    private static final int DELAI_ATTENTE = 500;
    private static final int PAS_ATTENTE = 10;
    private final InetAddress adresse;
    private final String nom;
    private Client client;
    private boolean fini;

    public Connexion(InetAddress adresse, String nom) {
        this.adresse = adresse;
        this.nom = nom;
    }

    public Client getClient() throws AnnulationException {
        while (!this.fini) {
            Outil.attendre(10);
        }
        if (this.client == null) {
            throw new AnnulationException("Connexion au serveur impossible");
        }
        return this.client;
    }

    @Override
    public void run() {
        try {
            this.client = new Client(this.adresse);
            this.client.lancer();
            this.client.write(new Paquet(TypePaquet.ID).addShort(this.nom));
            int i = 0;
            while (i < 50 && this.client.getID() == -1) {
                Outil.attendre(10);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fini = true;
    }
}

