/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau.client;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import fr.utt.lo02.uno.io.reseau.client.SalleReseau;
import fr.utt.lo02.uno.io.reseau.listeners.ReceiveListener;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.carte.ensemble.PlateauJeu;
import fr.utt.lo02.uno.temps.EvenementFutur;

public class PartieReseau
extends Partie
implements ReceiveListener {
    private final SalleReseau salle;

    public PartieReseau(SalleReseau salle, IO plateau) {
        super(salle.getJeu().getListeJoueurs(), new PlateauJeu(plateau));
        this.salle = salle;
        salle.getClient().addReceiveListener(this);
    }

    public SalleReseau getSalle() {
        return this.salle;
    }

    @Override
    public void commence() {
    }

    @Override
    public EvenementFutur ajoutEvenement(EvenementFutur e) {
        return e;
    }

    @Override
    public void affecteComportementOrdinateurs() {
    }

    @Override
    public void finPartie() {
        this.salle.getClient().removeReceiveListener(this);
        super.finPartie();
    }

    @Override
    public void recu(TypePaquet type, IO io) {
        switch (type) {
            case ACTION: {
                try {
                    if (this.getJoueurs().getJoueur().getTour() == null) break;
                    this.getJoueurs().getJoueur().getTour().faireAction(io.nextPositif());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case TOUR: {
                this.getJoueurs().setIndexJoueur(io.nextPositif());
                this.commenceTour();
                break;
            }
            case FIN_PARTIE: {
                this.finPartie();
                break;
            }
        }
    }
}

