/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau.client;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.exception.AnnulationException;
import fr.utt.lo02.uno.io.reseau.AbstractClient;
import fr.utt.lo02.uno.io.reseau.InfoSalle;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class RechercheServeur
extends AbstractClient {
    public static final int TEMPS_LIMITE_RECEPTION = 500;
    private InfoSalle infos;

    public RechercheServeur(InetAddress adresse) throws IOException {
        super(RechercheServeur.creerSocket(adresse));
    }

    public InfoSalle getInfoSalle() throws AnnulationException {
        if (this.infos == null) {
            throw new AnnulationException("Ce serveur n'a pas transmis ses informations");
        }
        return this.infos;
    }

    @Override
    protected void traite(TypePaquet type, IO in) {
        if (type == TypePaquet.INFO_SALLE) {
            this.infos = new InfoSalle(in);
            this.fermer();
        }
    }

    private static Socket creerSocket(InetAddress adresse) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(500);
        socket.connect(new InetSocketAddress(adresse, 9876), 500);
        return socket;
    }
}

