/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau.client;

import fr.utt.lo02.uno.io.exception.AnnulationException;
import fr.utt.lo02.uno.io.interfaces.Lancable;
import fr.utt.lo02.uno.io.reseau.AbstractClient;
import fr.utt.lo02.uno.io.reseau.InfoSalle;
import fr.utt.lo02.uno.io.reseau.client.RechercheServeur;
import fr.utt.lo02.uno.io.reseau.listeners.DeconnexionListener;
import fr.utt.lo02.uno.io.reseau.listeners.RechercheSalleListener;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class RechercheServeurs
extends Listenable
implements DeconnexionListener,
Runnable,
Lancable {
    private final List<RechercheServeur> serveurs;
    private final List<String> adresses;
    private boolean fin;

    public RechercheServeurs(List<String> adresses) {
        this.adresses = adresses;
        this.serveurs = new ArrayList<RechercheServeur>();
    }

    public void ajout(InetAddress adresse) throws IOException {
        RechercheServeur rs = new RechercheServeur(adresse);
        rs.addDeconnexionListener(this);
        this.serveurs.add(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminer() {
        this.fin = true;
        List<RechercheServeur> list = this.serveurs;
        synchronized (list) {
            for (RechercheServeur rs : this.serveurs) {
                rs.fermer();
            }
        }
    }

    public void addRechercheSalleListener(RechercheSalleListener l) {
        this.addListener(RechercheSalleListener.class, l);
    }

    public void removeRechercheSalleListener(RechercheSalleListener l) {
        this.removeListener(RechercheSalleListener.class, l);
    }

    public void notifyDecouverte(InfoSalle infos, InetAddress adresse) {
        RechercheSalleListener[] rechercheSalleListenerArray = (RechercheSalleListener[])this.getListeners(RechercheSalleListener.class);
        int n = rechercheSalleListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            RechercheSalleListener l = rechercheSalleListenerArray[n2];
            l.nouvelleSalle(adresse, infos);
            ++n2;
        }
    }

    @Override
    public boolean lancer() {
        new Thread(this).start();
        return true;
    }

    @Override
    public void deconnexion(AbstractClient client) {
        try {
            this.serveurs.remove(client);
            this.notifyDecouverte(((RechercheServeur)client).getInfoSalle(), client.getAdresse());
        }
        catch (AnnulationException annulationException) {
            // empty catch block
        }
        client.removeDeconnexionListener(this);
    }

    @Override
    public void run() {
        int i = 0;
        while (i < this.adresses.size() && !this.fin) {
            try {
                this.ajout(InetAddress.getByName(this.adresses.get(i)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        for (RechercheServeur rs : this.serveurs) {
            rs.lancer();
        }
    }
}

