/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau.client;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.exception.AnnulationException;
import fr.utt.lo02.uno.io.reseau.Paquet;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import fr.utt.lo02.uno.io.reseau.client.Client;
import fr.utt.lo02.uno.io.reseau.client.Connexion;
import fr.utt.lo02.uno.io.reseau.client.PartieReseau;
import fr.utt.lo02.uno.io.reseau.listeners.ReceiveListener;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SalleReseau
extends Salle
implements ReceiveListener {
    private final Client client;

    public SalleReseau(String nom, String adresse) throws UnknownHostException, AnnulationException {
        this(nom, InetAddress.getByName(adresse));
    }

    public SalleReseau(String nom) throws UnknownHostException, AnnulationException {
        this(nom, InetAddress.getLocalHost());
    }

    public SalleReseau(String nom, InetAddress adresse) throws AnnulationException {
        Connexion connexion = new Connexion(adresse, nom);
        connexion.start();
        this.client = connexion.getClient();
        this.setInformations(this.client.getInfos().getTypeJeu(), this.client.getInfos().getNombreJoueursMax(), this.client.getInfos().getNom());
        this.client.addReceiveListener(this);
        this.client.write(new Paquet(TypePaquet.AJOUT_JOUEUR));
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public void recu(TypePaquet type, IO io) {
        switch (type) {
            case AJOUT_JOUEUR: {
                this.getJeu().getListeJoueurs().ajoutJoueur(io.nextPositif(), new Joueur(TypeJoueur.values()[io.nextPositif()], io.nextShortString()));
                break;
            }
            case RETIRE_JOUEUR: {
                this.getJeu().getListeJoueurs().retireJoueur(io.nextPositif());
                break;
            }
            case COMMENCER: {
                this.getJeu().setPartie(new PartieReseau(this, io));
                this.getJeu().getPartie().lancer();
                break;
            }
        }
    }
}

