/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau.serveur;

import fr.utt.lo02.uno.io.exception.ServeurFullException;
import fr.utt.lo02.uno.io.interfaces.Fermable;
import fr.utt.lo02.uno.io.interfaces.FiltreEnvoi;
import fr.utt.lo02.uno.io.interfaces.IOable;
import fr.utt.lo02.uno.io.interfaces.Joignable;
import fr.utt.lo02.uno.io.interfaces.Lancable;
import fr.utt.lo02.uno.io.reseau.AbstractClient;
import fr.utt.lo02.uno.io.reseau.Paquet;
import fr.utt.lo02.uno.io.reseau.listeners.ConnexionListener;
import fr.utt.lo02.uno.io.reseau.listeners.DeconnexionListener;
import fr.utt.lo02.uno.io.reseau.serveur.ClientServeur;
import fr.utt.lo02.uno.io.reseau.serveur.filtreEnvoi.DefaultFiltreEnvoi;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractServeur
extends Listenable
implements Runnable,
Lancable,
Fermable,
DeconnexionListener,
Joignable {
    private final HashMap<Integer, ClientServeur> clients;
    private final List<Exception> erreurs;
    private final ServerSocket socket;
    private final Thread thread;

    public AbstractServeur(int port) throws IOException {
        this.socket = new ServerSocket(port);
        this.clients = new HashMap();
        this.erreurs = new ArrayList<Exception>();
        this.thread = new Thread(this);
    }

    public abstract Paquet getPaquetConnexion();

    public abstract int getMaxClients();

    public abstract ClientServeur creerClient(Socket var1) throws IOException, ServeurFullException;

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public InetAddress getAdresse() {
        return this.socket.getInetAddress();
    }

    public Collection<ClientServeur> getClients() {
        return this.clients.values();
    }

    public ClientServeur getClient(int id) {
        return this.clients.get(id);
    }

    public void deconnecterClients() {
        for (AbstractClient abstractClient : this.getClients()) {
            abstractClient.fermer();
        }
    }

    public void addConnexionListener(ConnexionListener l) {
        this.addListener(ConnexionListener.class, l);
    }

    public void removeConnexionListener(ConnexionListener l) {
        this.removeListener(ConnexionListener.class, l);
    }

    public void addDeconnexionListener(DeconnexionListener l) {
        this.addListener(DeconnexionListener.class, l);
    }

    public void removeDeconnexionListener(DeconnexionListener l) {
        this.removeListener(DeconnexionListener.class, l);
    }

    private void notifierConnexionListener(ClientServeur client) {
        ConnexionListener[] connexionListenerArray = (ConnexionListener[])this.getListeners(ConnexionListener.class);
        int n = connexionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnexionListener l = connexionListenerArray[n2];
            l.connexion(client);
            ++n2;
        }
    }

    private void notifyDeconnexionListener(ClientServeur client) {
        DeconnexionListener[] deconnexionListenerArray = (DeconnexionListener[])this.getListeners(DeconnexionListener.class);
        int n = deconnexionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeconnexionListener l = deconnexionListenerArray[n2];
            l.deconnexion(client);
            ++n2;
        }
    }

    private int getIDLibre() throws ServeurFullException {
        if (this.getClients().size() >= this.getMaxClients()) {
            throw new ServeurFullException();
        }
        int i = 0;
        while (i < this.getMaxClients()) {
            if (this.getClient(i) == null) {
                return i;
            }
            i = (byte)(i + 1);
        }
        throw new ServeurFullException();
    }

    public void envoyer(int id, IOable io) {
        this.getClient(id).write(io);
    }

    public void envoyerTous(IOable io) {
        this.envoyerFiltre(io, new DefaultFiltreEnvoi());
    }

    public void envoyerFiltre(IOable io, FiltreEnvoi filtre) {
        for (int id : this.clients.keySet()) {
            if (!filtre.doitEnvoyer(id, io)) continue;
            this.envoyer(id, io);
        }
    }

    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            try {
                ClientServeur c = this.creerClient(this.socket.accept());
                c.lancer();
                c.write(this.getPaquetConnexion());
            }
            catch (SocketException c) {
            }
            catch (ServeurFullException c) {
            }
            catch (Exception e) {
                e.printStackTrace();
                this.erreurs.add(e);
            }
        }
        if (!this.erreurs.isEmpty()) {
            System.err.println(String.valueOf(this.erreurs.size()) + " erreurs : ");
        }
    }

    @Override
    public boolean rejoindre(ClientServeur c) {
        try {
            c.setID(this.getIDLibre());
            this.clients.put(c.getID(), c);
            c.addDeconnexionListener(this);
            this.notifierConnexionListener(c);
            return true;
        }
        catch (ServeurFullException e) {
            c.fermer();
            return false;
        }
    }

    @Override
    public void deconnexion(AbstractClient client) {
        ClientServeur c = this.clients.remove(client.getID());
        if (c != null) {
            c.removeDeconnexionListener(this);
            this.notifyDeconnexionListener(c);
        }
    }

    @Override
    public boolean fermer() {
        try {
            this.deconnecterClients();
            this.socket.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean lancer() {
        if (!this.thread.isAlive()) {
            this.thread.start();
            return true;
        }
        return false;
    }
}

