/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau.serveur;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.reseau.AbstractClient;
import fr.utt.lo02.uno.io.reseau.Paquet;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import fr.utt.lo02.uno.io.reseau.serveur.Serveur;
import fr.utt.lo02.uno.jeu.exception.JeuException;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import java.io.IOException;
import java.net.Socket;

public class ClientServeur
extends AbstractClient {
    private final Serveur serveur;
    private Joueur joueur;

    public ClientServeur(Serveur serveur, Socket socket) throws IOException {
        super(socket);
        this.serveur = serveur;
    }

    @Override
    protected void traite(TypePaquet type, IO io) {
        switch (type) {
            case ID: {
                try {
                    if (!this.serveur.rejoindre(this)) break;
                    this.joueur = new Joueur(TypeJoueur.JOUEUR_RESEAU, io.nextShortString());
                    this.serveur.getSalle().getJeu().getListeJoueurs().ajoutJoueur(this.joueur);
                    this.write(new Paquet(TypePaquet.ID, this.getID()));
                }
                catch (JeuException e) {
                    e.printStackTrace();
                }
                break;
            }
            case AJOUT_JOUEUR: {
                int id = 0;
                for (Joueur j : this.serveur.getSalle().getJeu().getListeJoueurs().getListeJoueurs()) {
                    this.write(new Paquet(TypePaquet.AJOUT_JOUEUR).addBytePositif(id).addBytePositif((j == this.joueur ? TypeJoueur.HUMAIN : j.getType()).ordinal()).addShort(j.getNom()));
                    ++id;
                }
                break;
            }
            case TEMPS: {
                this.write(new Paquet(TypePaquet.TEMPS, this.serveur.getTemps()));
                break;
            }
            case ACTION: {
                try {
                    TourJoueur t = this.serveur.getSalle().getJeu().getPartie().getJoueurs().getJoueur().getTour();
                    if (t == null) break;
                    t.faireAction(io.nextPositif());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case MESSAGE: {
                this.serveur.envoyerTous(io);
                break;
            }
        }
    }
}

