/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.io.reseau.serveur;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.exception.ServeurFullException;
import fr.utt.lo02.uno.io.reseau.AbstractClient;
import fr.utt.lo02.uno.io.reseau.InfoSalle;
import fr.utt.lo02.uno.io.reseau.Paquet;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import fr.utt.lo02.uno.io.reseau.serveur.AbstractServeur;
import fr.utt.lo02.uno.io.reseau.serveur.ClientServeur;
import fr.utt.lo02.uno.io.reseau.serveur.DiffusionSalle;
import fr.utt.lo02.uno.io.reseau.serveur.EvenementNouvellePartie;
import fr.utt.lo02.uno.io.reseau.serveur.filtreEnvoi.FiltreEnvoiExclusionID;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.action.ActionJoueur;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.ActionTourListener;
import fr.utt.lo02.uno.jeu.listener.JeuListener;
import fr.utt.lo02.uno.jeu.listener.ListeJoueurListener;
import fr.utt.lo02.uno.jeu.listener.PartieListener;
import fr.utt.lo02.uno.temps.Evenement;
import fr.utt.lo02.uno.temps.Evenementiel;
import fr.utt.lo02.uno.temps.Horloge;
import fr.utt.lo02.uno.temps.Periodique;
import java.io.IOException;
import java.net.Socket;
import java.util.List;

public class Serveur
extends AbstractServeur
implements ListeJoueurListener,
Evenementiel,
PartieListener,
JeuListener,
ActionTourListener {
    public static final int DEFAULT_PORT = 9876;
    private final DiffusionSalle diffusion;
    private final Horloge horloge;
    private final Salle salle;
    private Evenement evenement;
    private TourJoueur tour;

    public Serveur(Salle salle) throws IOException {
        this(9876, salle);
    }

    public Serveur(int port, Salle salle) throws IOException {
        super(port);
        this.salle = salle;
        this.diffusion = new DiffusionSalle(salle.getInfos());
        this.horloge = new Horloge();
        salle.getJeu().getListeJoueurs().addListeJoueursListener(this);
        salle.getJeu().addJeuListener(this);
    }

    public Horloge getHorloge() {
        return this.horloge;
    }

    public Salle getSalle() {
        return this.salle;
    }

    public void envoyerTemps() {
        this.envoyerTous(new Paquet(TypePaquet.TEMPS, this.getTemps()));
    }

    public int getTemps() {
        return Math.max(0, this.evenement.getTemps() - this.horloge.getTemps());
    }

    @Override
    public void deconnexion(AbstractClient client) {
        super.deconnexion(client);
        this.salle.getJeu().getListeJoueurs().retireJoueur(client.getID());
    }

    @Override
    public ClientServeur getClient(int id) {
        return super.getClient(id);
    }

    @Override
    public boolean fermer() {
        this.diffusion.fermer();
        return super.fermer() && this.horloge.terminer();
    }

    @Override
    public boolean lancer() {
        try {
            this.diffusion.lancer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.evenement = new Evenement(Configuration.TEMPS_PARTIE_REJOIGNABLE, this);
        this.horloge.addEvenementFutur(this.evenement);
        return super.lancer() && this.horloge.lancer();
    }

    @Override
    public Paquet getPaquetConnexion() {
        return new Paquet(new InfoSalle(this.salle));
    }

    @Override
    public int getMaxClients() {
        return this.salle.getJeu().getListeJoueurs().getMaxJoueurs();
    }

    @Override
    public ClientServeur creerClient(Socket socket) throws IOException, ServeurFullException {
        if (this.salle.getJeu().getListeJoueurs().estPleine()) {
            throw new ServeurFullException();
        }
        return new ClientServeur(this, socket);
    }

    @Override
    public void ajout(int id, Joueur joueur) {
        this.envoyerFiltre(new Paquet(TypePaquet.AJOUT_JOUEUR).addBytePositif(id).addBytePositif(joueur.getType().ordinal()).addShort(joueur.getNom()), new FiltreEnvoiExclusionID(id));
        if (this.salle.getJeu().getListeJoueurs().estPleine()) {
            this.evenement.setTemps(0);
        }
    }

    @Override
    public void retire(int id, Joueur joueur) {
        this.envoyerTous(new Paquet(TypePaquet.RETIRE_JOUEUR, id));
    }

    @Override
    public void evenement(Periodique p) {
        if (this.salle.getJeu().getListeJoueurs().aHumain()) {
            if (!this.salle.getJeu().getListeJoueurs().estPleine()) {
                this.salle.getJeu().getListeJoueurs().combler();
            }
            this.diffusion.fermer();
            this.evenement = new Evenement(Configuration.TEMPS_COMMENCER_PARTIE_SALLE_PLEINE, new EvenementNouvellePartie(this.salle.getJeu()));
            this.horloge.addEvenementFutur(this.evenement);
            this.envoyerTemps();
        } else {
            this.evenement = new Evenement(Configuration.TEMPS_PARTIE_REJOIGNABLE, this);
            this.horloge.addEvenementFutur(this.evenement);
        }
    }

    @Override
    public void finPartie(Partie partie) {
        partie.removePartieListener(this);
    }

    @Override
    public void debutPartie(Partie partie) {
        this.envoyerTous(new Paquet(TypePaquet.COMMENCER, this.salle.getJeu().getPartie().getPlateau()));
    }

    @Override
    public void nouvellePartie(Partie partie) {
        partie.addPartieListener(this);
    }

    @Override
    public void finPartie(Partie partie, ResultatPartie resultats) {
        partie.removePartieListener(this);
    }

    @Override
    public void debutTour(int id, TourJoueur tour) {
        this.envoyerTous(new Paquet(TypePaquet.TOUR).addBytePositif(id));
        if (this.tour != null) {
            this.tour.removeActionTourListener(this);
        }
        this.tour = tour;
        tour.addActionTourListener(this);
    }

    @Override
    public void action(int idAction, ActionJoueur action) {
        this.envoyerTous(new Paquet(TypePaquet.ACTION, idAction));
    }

    @Override
    public void finJeu(List<ResultatPartie> resultats, Jeu jeu) {
        this.fermer();
    }

    @Override
    public void passeTour(int id) {
        this.envoyerTous(new Paquet(TypePaquet.TOUR).addBytePositif(id));
    }
}

