/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu;

import fr.utt.lo02.uno.jeu.action.Action;
import fr.utt.lo02.uno.jeu.action.ActionChoixCouleur;
import fr.utt.lo02.uno.jeu.action.ActionJoueur;
import fr.utt.lo02.uno.jeu.action.ActionPoseCarte;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.CarteGraphique;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.PanelTasCartes;
import fr.utt.lo02.uno.ui.listener.ChoixCouleurListener;
import fr.utt.lo02.uno.ui.listener.CliqueCarteListener;
import fr.utt.lo02.uno.ui.listener.PanelActionJoueurListener;
import fr.utt.lo02.uno.ui.listener.PanelTasCarteListener;
import java.util.List;

public abstract class Controleur
implements CliqueCarteListener,
PanelTasCarteListener,
ChoixCouleurListener,
PanelActionJoueurListener {
    private final Joueur joueur;

    public Controleur(Joueur joueur) {
        this.joueur = joueur;
    }

    public Joueur getJoueur() {
        return this.joueur;
    }

    public abstract void faireAction(int var1);

    public int getIDActionPose(Carte carte) {
        List<ActionJoueur> actions = this.joueur.getTour().getActions().getActionsPossibles();
        int id = 0;
        while (id < actions.size()) {
            ActionJoueur a = actions.get(id);
            if (a.getType() == Action.POSE && ((ActionPoseCarte)a).getCarte() == carte) {
                return id;
            }
            ++id;
        }
        throw new IllegalArgumentException();
    }

    public int getIDActionChoixCouleur(Couleur couleur) {
        List<ActionJoueur> actions = this.joueur.getTour().getActions().getActionsPossibles();
        int id = 0;
        while (id < actions.size()) {
            ActionJoueur a = actions.get(id);
            if (a.getType() == Action.CHOIX_COULEUR && ((ActionChoixCouleur)a).getCouleur() == couleur) {
                return id;
            }
            ++id;
        }
        throw new IllegalArgumentException();
    }

    public int getID(Action action) {
        List<ActionJoueur> actions = this.joueur.getTour().getActions().getActionsPossibles();
        int id = 0;
        while (id < actions.size()) {
            ActionJoueur a = actions.get(id);
            if (a.getType() == action) {
                return id;
            }
            ++id;
        }
        throw new IllegalArgumentException("Cette action ne peut etre faite");
    }

    @Override
    public void clique(CarteGraphique carte) {
        this.faireAction(this.getIDActionPose(carte.getCarte()));
    }

    @Override
    public void clique(PanelTasCartes tas) {
        this.faireAction(this.getID(Action.PIOCHE));
    }

    @Override
    public void choixCouleur(Couleur couleur) {
        this.faireAction(this.getIDActionChoixCouleur(couleur));
    }

    @Override
    public void uno() {
        this.faireAction(this.getID(Action.UNO));
    }

    @Override
    public void passeTour() {
        this.faireAction(this.getID(Action.FIN_TOUR));
    }

    @Override
    public void contreUno() {
        this.faireAction(this.getID(Action.CONTRE_UNO));
    }

    @Override
    public void contreBluff(boolean contreBluffe) {
        this.faireAction(this.getID(contreBluffe ? Action.BLUFF : Action.NON_BLUFF));
    }
}

