/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.ListeJoueurs;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.JeuListener;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import fr.utt.lo02.uno.jeu.listener.PartieListener;
import fr.utt.lo02.uno.jeu.variantes.TypeJeu;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.temps.Evenement;
import fr.utt.lo02.uno.temps.Evenementiel;
import fr.utt.lo02.uno.temps.Periodique;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Jeu
extends Listenable
implements PartieListener,
Evenementiel {
    private final List<ResultatPartie> historiqueParties;
    private final TypeJeu type;
    private final ListeJoueurs joueurs;
    private Partie partie;

    public Jeu(TypeJeu type, ListeJoueurs joueurs) {
        this.joueurs = joueurs;
        this.type = type;
        this.historiqueParties = new ArrayList<ResultatPartie>();
    }

    protected Jeu(TypeJeu type, int nombre) {
        this(type, new ListeJoueurs(nombre));
    }

    public Jeu(int nombre) {
        this(TypeJeu.CLASSIQUE, nombre);
    }

    public ListeJoueurs getListeJoueurs() {
        return this.joueurs;
    }

    public Partie creerPartie() {
        return new Partie(this.joueurs);
    }

    public void nouvellePartie() {
        this.setPartie(this.creerPartie());
        this.partie.lancer();
    }

    public void setPartie(Partie nouvellePartie) {
        if (this.partie != null) {
            this.partie.removePartieListener(this);
            this.partie.getHorloge().terminer();
            for (Joueur j : this.joueurs.getListeJoueurs()) {
                j.getMain().vider();
            }
        }
        this.partie = nouvellePartie;
        this.partie.addPartieListener(this);
        JeuListener[] jeuListenerArray = (JeuListener[])this.getListeners(JeuListener.class);
        int n = jeuListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            JeuListener l = jeuListenerArray[n2];
            l.nouvellePartie(nouvellePartie);
            ++n2;
        }
    }

    public Partie getPartie() {
        return this.partie;
    }

    public List<ResultatPartie> getResultats() {
        return this.historiqueParties;
    }

    public TypeJeu getType() {
        return this.type;
    }

    public boolean estJeuFini() {
        for (Integer i : ResultatPartie.getPoints(this.historiqueParties).values()) {
            if (i < Configuration.SCORE_DEFAITE) continue;
            return true;
        }
        return false;
    }

    public void addJeuListener(JeuListener l) {
        this.addListener(JeuListener.class, l);
    }

    public void removeJeuListener(JeuListener l) {
        this.removeListener(JeuListener.class, l);
    }

    public String getGagnant() {
        Map.Entry<Joueur, Integer> e = ResultatPartie.getGagnant(this.historiqueParties);
        return e.getKey() + " " + Texte.get("gagne le jeu avec") + " " + e.getValue() + " " + Texte.get("points");
    }

    @Override
    public void evenement(Periodique p) {
        this.nouvellePartie();
    }

    @Override
    public void finPartie(Partie partie) {
        JeuListener l;
        ResultatPartie r = new ResultatPartie(partie.getJoueurs().getListeJoueurs());
        this.historiqueParties.add(r);
        JeuListener[] jeuListenerArray = (JeuListener[])this.getListeners(JeuListener.class);
        int n = jeuListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            l = jeuListenerArray[n2];
            l.finPartie(partie, r);
            ++n2;
        }
        if (this.estJeuFini()) {
            jeuListenerArray = (JeuListener[])this.getListeners(JeuListener.class);
            n = jeuListenerArray.length;
            n2 = 0;
            while (n2 < n) {
                l = jeuListenerArray[n2];
                l.finJeu(this.historiqueParties, this);
                ++n2;
            }
        } else {
            partie.ajoutEvenement(new Evenement(Configuration.TEMPS_AFFICHAGE_RESULTATS, this));
        }
    }

    @Override
    public void debutPartie(Partie partie) {
    }

    @Override
    public void debutTour(int id, TourJoueur tour) {
    }

    @Override
    public void passeTour(int id) {
    }
}

