/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.base.Console;
import fr.utt.lo02.uno.jeu.action.generateur.ia.ComportementOrdinateur;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.ensemble.PlateauJeu;
import fr.utt.lo02.uno.jeu.evenement.EvenementFinPartie;
import fr.utt.lo02.uno.jeu.evenement.EvenementNouveauTour;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.ListeJoueurs;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import fr.utt.lo02.uno.jeu.listener.DeplacementCarteListener;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import fr.utt.lo02.uno.jeu.listener.PartieListener;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.temps.Evenement;
import fr.utt.lo02.uno.temps.EvenementFutur;
import fr.utt.lo02.uno.temps.Horloge;
import java.util.HashMap;
import java.util.Map;

public class Partie
extends Listenable {
    private final Map<Joueur, ComportementOrdinateur> ia;
    private final ListeJoueurs joueurs;
    private final Horloge horloge;
    private final PlateauJeu plateau;
    private boolean joue;

    public Partie(ListeJoueurs joueurs, PlateauJeu plateau) {
        this.joueurs = joueurs;
        this.plateau = plateau;
        this.horloge = new Horloge();
        this.ia = new HashMap<Joueur, ComportementOrdinateur>();
    }

    public Partie(ListeJoueurs joueurs) {
        this(joueurs, new PlateauJeu());
    }

    public EvenementFutur ajoutEvenement(EvenementFutur e) {
        this.horloge.addEvenementFutur(e);
        return e;
    }

    public void lancer() {
        if (this.joue) {
            throw new IllegalStateException(Texte.get("Cette partie est d\ufffdj\ufffd lanc\ufffde"));
        }
        this.joue = true;
        this.joueurs.combler();
        this.affecteComportementOrdinateurs();
        PartieListener[] partieListenerArray = (PartieListener[])this.getListeners(PartieListener.class);
        int n = partieListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PartieListener l = partieListenerArray[n2];
            l.debutPartie(this);
            ++n2;
        }
        this.horloge.lancer();
        this.distribuer();
        this.choisirJoueurCommence();
        this.joueurs.precedent();
        this.plateau.getTalon().getCarte().faireEffet(this, true);
        this.joueurs.suivant();
        Console.getInstance().affiche(" --- La partie commence ! --- ");
        this.commence();
    }

    public void affecteComportementOrdinateurs() {
        Joueur[] joueurArray = this.joueurs.getJoueurs();
        int n = joueurArray.length;
        int n2 = 0;
        while (n2 < n) {
            Joueur j = joueurArray[n2];
            if (j.getType() == TypeJoueur.ORDINATEUR) {
                ComportementOrdinateur c = new ComportementOrdinateur(this.horloge);
                this.ia.put(j, c);
                j.addTourJoueurListener(c);
            }
            ++n2;
        }
    }

    public void choisirJoueurCommence() {
        Carte[] cartes = new Carte[this.joueurs.getMaxJoueurs()];
        int i = 0;
        while (i < cartes.length) {
            cartes[i] = this.plateau.piocher();
            this.plateau.getTalon().poser(cartes[i]);
            ++i;
        }
        this.joueurs.setIndexJoueur(Partie.getCarteMax(cartes));
    }

    public void finPartie() {
        this.joueurs.getJoueurSuivant().activeEffets(this, true);
        for (Map.Entry<Joueur, ComportementOrdinateur> e : this.ia.entrySet()) {
            e.getKey().removeTourJoueurListener(e.getValue());
        }
        this.ia.clear();
        Console.getInstance().affiche(this.joueurs.getJoueur() + " gagne la partie !");
        PartieListener[] partieListenerArray = (PartieListener[])this.getListeners(PartieListener.class);
        int n = partieListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PartieListener l = partieListenerArray[n2];
            l.finPartie(this);
            ++n2;
        }
    }

    public void commence() {
        this.commenceTour();
    }

    public void distribuer() {
        this.distribuer(Configuration.NOMBRE_CARTES);
    }

    public void distribuer(int nombre) {
        if (nombre < 0) {
            throw new IllegalArgumentException("Un minimum de 0 cartes doit etre distribue");
        }
        Console.getInstance().affiche("Distribution des cartes (" + nombre + ")");
        int i = 0;
        while (i < nombre) {
            Joueur[] joueurArray = this.joueurs.getJoueurs();
            int n = joueurArray.length;
            int n2 = 0;
            while (n2 < n) {
                Joueur j = joueurArray[n2];
                j.getMain().ajoutCarte(this.plateau.piocher());
                ++n2;
            }
            ++i;
        }
    }

    public ListeJoueurs getJoueurs() {
        return this.joueurs;
    }

    public PlateauJeu getPlateau() {
        return this.plateau;
    }

    public void nouveauTour() {
        this.joueurs.suivant();
        this.commenceTour();
    }

    public void commenceTour() {
        int index = this.joueurs.getIDJoueur();
        TourJoueur tour = this.joueurs.getJoueur().debutTour(this, Configuration.TEMPS_TOUR);
        if (tour != null) {
            PartieListener[] partieListenerArray = (PartieListener[])this.getListeners(PartieListener.class);
            int n = partieListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PartieListener l = partieListenerArray[n2];
                l.debutTour(this.joueurs.getIDJoueur(), tour);
                ++n2;
            }
        } else {
            PartieListener[] partieListenerArray = (PartieListener[])this.getListeners(PartieListener.class);
            int n = partieListenerArray.length;
            int n3 = 0;
            while (n3 < n) {
                PartieListener l = partieListenerArray[n3];
                l.passeTour(index);
                ++n3;
            }
        }
    }

    public void finTour() {
        this.joueurs.getJoueur().finTour();
        if (this.joueurs.getJoueur().getMain().estVide()) {
            this.horloge.addEvenementFutur(new Evenement(2, new EvenementFinPartie(this)));
        } else {
            this.ajoutEvenement(new Evenement(Configuration.TEMPS_INTERTOUR, new EvenementNouveauTour(this)));
        }
    }

    public Horloge getHorloge() {
        return this.horloge;
    }

    public boolean joue() {
        return this.joue;
    }

    public void addPartieListener(PartieListener l) {
        this.addListener(PartieListener.class, l);
    }

    public void removePartieListener(PartieListener l) {
        this.removeListener(PartieListener.class, l);
    }

    public void notifyDeplacementCarte(Object source, Object cible, Carte c) {
        DeplacementCarteListener[] deplacementCarteListenerArray = (DeplacementCarteListener[])this.getListeners(DeplacementCarteListener.class);
        int n = deplacementCarteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeplacementCarteListener l = deplacementCarteListenerArray[n2];
            l.deplacement(source, cible, c);
            ++n2;
        }
    }

    public void addDeplacementCarteListener(DeplacementCarteListener l) {
        this.addListener(DeplacementCarteListener.class, l);
    }

    public void removeDeplacementCarteListener(DeplacementCarteListener l) {
        this.removeListener(DeplacementCarteListener.class, l);
    }

    public static int getCarteMax(Carte ... cartes) {
        int max = 0;
        int id = 0;
        int i = 0;
        while (i < cartes.length) {
            if (cartes[i].getValeurPoints() > max) {
                id = i;
            }
            ++i;
        }
        return id;
    }
}

