/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu;

import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResultatPartie {
    private final Map<Joueur, List<Carte>> resultat = new HashMap<Joueur, List<Carte>>();

    public ResultatPartie(Iterable<Joueur> joueurs) {
        for (Joueur j : joueurs) {
            ArrayList<Carte> cartes = new ArrayList<Carte>();
            for (Carte c : j.getMain().getCartes()) {
                cartes.add(c.dupliquer());
            }
            this.resultat.put(j, cartes);
        }
    }

    public Set<Joueur> getJoueurs() {
        return this.resultat.keySet();
    }

    public List<Carte> getCartes(Joueur joueur) {
        return this.resultat.get(joueur);
    }

    public int getPoints(Joueur joueur) {
        int pts = 0;
        for (Carte c : this.getCartes(joueur)) {
            pts += c.getValeurPoints();
        }
        return pts;
    }

    public Map<Joueur, Integer> getPoints() {
        HashMap<Joueur, Integer> result = new HashMap<Joueur, Integer>();
        for (Joueur joueur : this.getJoueurs()) {
            result.put(joueur, this.getPoints(joueur));
        }
        return result;
    }

    public Joueur getGagnant() {
        for (Map.Entry<Joueur, List<Carte>> result : this.resultat.entrySet()) {
            if (!result.getValue().isEmpty()) continue;
            return result.getKey();
        }
        throw new IllegalAccessError("Impossible de determiner le gagnant");
    }

    public static Map<Joueur, Integer> getPoints(List<ResultatPartie> resultats) {
        HashMap<Joueur, Integer> result = new HashMap<Joueur, Integer>();
        for (ResultatPartie rp : resultats) {
            Map<Joueur, Integer> r = rp.getPoints();
            for (Map.Entry<Joueur, Integer> e : r.entrySet()) {
                Joueur j = e.getKey();
                if (!result.containsKey(j)) {
                    result.put(j, 0);
                }
                result.put(j, e.getValue() + (Integer)result.get(j));
            }
        }
        return result;
    }

    public static Map.Entry<Joueur, Integer> getGagnant(List<ResultatPartie> resultats) {
        Map.Entry<Joueur, Integer> gagnant = null;
        for (Map.Entry<Joueur, Integer> e : ResultatPartie.getPoints(resultats).entrySet()) {
            if (gagnant != null && e.getValue() >= gagnant.getValue()) continue;
            gagnant = e;
        }
        return gagnant;
    }
}

