/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu;

import fr.utt.lo02.uno.base.Generateur;
import fr.utt.lo02.uno.io.reseau.InfoSalle;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.action.generateur.ControleurPartieHorsLigne;
import fr.utt.lo02.uno.jeu.action.generateur.Strategie;
import fr.utt.lo02.uno.jeu.action.generateur.ia.ComportementOrdinateur;
import fr.utt.lo02.uno.jeu.exception.JeuException;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import fr.utt.lo02.uno.jeu.variantes.TypeJeu;
import fr.utt.lo02.uno.temps.Horloge;
import fr.utt.lo02.uno.ui.Fenetre;
import fr.utt.lo02.uno.ui.composant.ecran.EcranPartie;

public class Salle {
    private String nom;
    private Jeu jeu;

    public Salle() {
        this(TypeJeu.CLASSIQUE, 2, "Sans nom");
    }

    public Salle(TypeJeu type, int nombreJoueursAdmissibles, String nom) {
        this.setInformations(type, nombreJoueursAdmissibles, nom);
    }

    public void setInformations(TypeJeu type, int nombreJoueursAdmissibles, String nom) {
        this.nom = nom;
        this.jeu = type.creerJeu(nombreJoueursAdmissibles);
    }

    public InfoSalle getInfos() {
        return new InfoSalle(this);
    }

    public String getNom() {
        return this.nom;
    }

    public Jeu getJeu() {
        return this.jeu;
    }

    public static void partieRapide(Strategie principale, Strategie ... autres) {
        TourJoueurListener[] t = new TourJoueurListener[autres.length];
        Horloge p = new Horloge();
        int i = 0;
        while (i < t.length) {
            t[i] = new ComportementOrdinateur(p, autres[i]);
            ++i;
        }
        Salle.partieRapide(new ComportementOrdinateur(p, principale), t);
        p.lancer();
    }

    public static void partieRapide(TourJoueurListener principal, TourJoueurListener ... autres) {
        Salle salle = new Salle(TypeJeu.CLASSIQUE, 1 + autres.length, "Salle rapide");
        Joueur pj = new Joueur(TypeJoueur.HUMAIN, Generateur.getInstance().getNomPrincipal());
        pj.addTourJoueurListener(principal);
        try {
            salle.getJeu().getListeJoueurs().ajoutJoueur(pj);
        }
        catch (JeuException e1) {
            e1.printStackTrace();
        }
        TourJoueurListener[] tourJoueurListenerArray = autres;
        int n = autres.length;
        int n2 = 0;
        while (n2 < n) {
            TourJoueurListener l = tourJoueurListenerArray[n2];
            try {
                Joueur j = new Joueur(TypeJoueur.HUMAIN, Generateur.getInstance().getNom());
                j.addTourJoueurListener(l);
                salle.getJeu().getListeJoueurs().ajoutJoueur(j);
            }
            catch (JeuException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        salle.getJeu().nouvellePartie();
        new Fenetre(new EcranPartie(new ControleurPartieHorsLigne(pj), pj, salle));
    }
}

