/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.action;

import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.action.Action;
import fr.utt.lo02.uno.jeu.action.ActionJoueur;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.CartePlusQuatre;
import fr.utt.lo02.uno.jeu.carte.ensemble.MainJoueur;
import fr.utt.lo02.uno.jeu.effet.EffetPioche;
import fr.utt.lo02.uno.jeu.effet.EffetPlusQuatre;

public class ActionBluff
implements ActionJoueur {
    private final EffetPlusQuatre effet;

    public ActionBluff(EffetPlusQuatre effet) {
        this.effet = effet;
    }

    @Override
    public Action getType() {
        return Action.BLUFF;
    }

    @Override
    public void faireEffet(Partie partie) {
        partie.getJoueurs().getJoueur().supprimeEffet(this.effet);
        int nombre = 6;
        MainJoueur main = partie.getJoueurs().getJoueur().getMain();
        if (ActionBluff.aRaison(partie)) {
            nombre -= 2;
            main = partie.getJoueurs().getJoueurPrecedent().getMain();
        } else {
            partie.getJoueurs().getJoueur().getTour().getActions().passer();
        }
        new EffetPioche(nombre).faireEffet(partie, main);
    }

    public String toString() {
        return "contre-bluffe";
    }

    public static boolean aRaison(Partie partie) {
        Carte c1 = partie.getPlateau().getTalon().getCartePrecedente();
        for (Carte c2 : partie.getJoueurs().getJoueurPrecedent().getMain().getCartes()) {
            if (!c1.compatible(c2) || c2 instanceof CartePlusQuatre) continue;
            return true;
        }
        return false;
    }
}

