/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.action;

import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.action.Action;
import fr.utt.lo02.uno.jeu.action.ActionBluff;
import fr.utt.lo02.uno.jeu.action.ActionChoixCouleur;
import fr.utt.lo02.uno.jeu.action.ActionContreUno;
import fr.utt.lo02.uno.jeu.action.ActionFinTour;
import fr.utt.lo02.uno.jeu.action.ActionJoueur;
import fr.utt.lo02.uno.jeu.action.ActionNonBluff;
import fr.utt.lo02.uno.jeu.action.ActionPioche;
import fr.utt.lo02.uno.jeu.action.ActionPoseCarte;
import fr.utt.lo02.uno.jeu.action.ActionUno;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.CarteChangeCouleur;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.effet.Effet;
import fr.utt.lo02.uno.jeu.effet.EffetPlusQuatre;
import fr.utt.lo02.uno.jeu.exception.ActionInvalideException;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import java.util.ArrayList;
import java.util.List;

public class AutomateActions {
    private final List<ActionJoueur> actions;
    private final Partie partie;
    private final Joueur joueur;
    private List<ActionJoueur> actionsPossibles;
    private boolean passe;

    public AutomateActions(Joueur joueur, Partie partie) {
        this.partie = partie;
        this.joueur = joueur;
        this.actions = new ArrayList<ActionJoueur>();
        this.calculeActionsPossibles();
    }

    public void passer() {
        this.passe = true;
    }

    public Partie getPartie() {
        return this.partie;
    }

    public Joueur getJoueur() {
        return this.joueur;
    }

    public boolean estTour() {
        return this.partie.getJoueurs().getJoueur() == this.joueur;
    }

    public boolean estFini() {
        return this.getActionsPossibles().isEmpty();
    }

    public ActionJoueur getDerniereAction() {
        return this.actions.isEmpty() ? null : this.actions.get(this.actions.size() - 1);
    }

    public List<ActionJoueur> getActionsPossibles() {
        return this.actionsPossibles == null ? this.calculeActionsPossibles() : this.actionsPossibles;
    }

    public List<ActionJoueur> ajouteAction(ActionJoueur action) {
        this.actions.add(action);
        return this.calculeActionsPossibles();
    }

    public List<ActionJoueur> calculeActionsPossibles() {
        this.actionsPossibles = new ArrayList<ActionJoueur>();
        if (this.peutBluffer()) {
            EffetPlusQuatre e = this.getEffetPlusQuatre();
            this.actionsPossibles.add(new ActionBluff(e));
            this.actionsPossibles.add(new ActionNonBluff(e));
        } else {
            if (this.peutChoisirCouleur()) {
                Couleur[] couleurArray = Couleur.values();
                int n = couleurArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Couleur c = couleurArray[n2];
                    this.actionsPossibles.add(new ActionChoixCouleur(c));
                    ++n2;
                }
            }
            if (this.peutPiocher()) {
                this.actionsPossibles.add(new ActionPioche());
            }
            for (Carte carte : this.getCartesPosables()) {
                this.actionsPossibles.add(new ActionPoseCarte(carte));
            }
            if (this.peutUno()) {
                this.actionsPossibles.add(new ActionUno());
            }
            if (this.peutContreUno()) {
                this.actionsPossibles.add(new ActionContreUno());
            }
            if (this.peutTerminerTour()) {
                this.actionsPossibles.add(new ActionFinTour());
            }
        }
        return this.actionsPossibles;
    }

    public List<Carte> getCartesPosables() {
        ArrayList<Carte> cartes = new ArrayList<Carte>();
        for (Carte c : this.joueur.getMain().getCartes()) {
            if (!this.peutPoser(c)) continue;
            cartes.add(c);
        }
        return cartes;
    }

    public void testeAction(ActionJoueur action) throws ActionInvalideException {
        String message = this.getMessageErreur(action);
        if (message != null) {
            throw new ActionInvalideException(message);
        }
    }

    public String getMessageErreur(ActionJoueur action) {
        switch (action.getType()) {
            case POSE: {
                if (this.peutPoser(((ActionPoseCarte)action).getCarte())) break;
                return "Vous ne pouvez pas poser cette carte";
            }
            case PIOCHE: {
                if (this.peutPiocher()) break;
                return "Vous ne pouvez pas piocher de carte";
            }
            case CHOIX_COULEUR: {
                if (this.peutChoisirCouleur()) break;
                return "Vous ne pouvez pas changer la couleur de cette carte";
            }
            case FIN_TOUR: {
                if (this.peutTerminerTour()) break;
                return "Vous ne pouvez pas terminer votre tour";
            }
            case UNO: {
                if (this.peutUno()) break;
                return "Il ne doit vous rester qu'une carte pour declarer Uno !";
            }
            case CONTRE_UNO: {
                if (this.peutContreUno()) break;
                return "Vous ne pouvez pas declarer contre uno";
            }
            case BLUFF: 
            case NON_BLUFF: {
                if (this.peutBluffer()) break;
                return "Vous ne pouvez pas bluffer";
            }
        }
        return null;
    }

    public boolean peutTerminerTour() {
        ActionJoueur a = this.getDerniereAction();
        return !this.aFini() && (this.peutUno() || a != null && a.getType() == Action.PIOCHE && this.getCartesPosables().size() > 0);
    }

    public boolean peutChoisirCouleur() {
        Carte c = this.partie.getPlateau().getTalon().getCarte();
        return c instanceof CarteChangeCouleur && c.getCouleur() == null;
    }

    public boolean peutPiocher() {
        if (this.passe || this.peutBluffer()) {
            return false;
        }
        for (ActionJoueur a : this.actions) {
            if (a.getType() != Action.POSE && a.getType() != Action.PIOCHE) continue;
            return false;
        }
        return !this.aFini();
    }

    public boolean aFini() {
        return this.aDeja(Action.FIN_TOUR);
    }

    public boolean peutUno() {
        return !this.peutChoisirCouleur() && !this.joueur.aDitUno() && this.joueur.getMain().getCartes().size() == 1 && !this.aFini() && this.aDeja(Action.POSE);
    }

    public boolean peutContreUno() {
        Joueur j = this.partie.getJoueurs().getJoueurPrecedent();
        return !this.peutBluffer() && this.actions.isEmpty() && j.estUno() && !j.aDitUno();
    }

    public boolean peutBluffer() {
        if (!this.actions.isEmpty()) {
            return false;
        }
        return this.getEffetPlusQuatre() != null;
    }

    public boolean peutPoser(Carte carte) {
        return !this.passe && !this.peutBluffer() && !this.aFini() && !this.aDeja(Action.POSE) && this.partie.getPlateau().getTalon().getCarte().compatible(carte);
    }

    public boolean peutFaire(ActionJoueur action) {
        try {
            this.testeAction(action);
            return true;
        }
        catch (ActionInvalideException e) {
            return false;
        }
    }

    public boolean aDeja(Action action) {
        for (ActionJoueur a : this.actions) {
            if (a.getType() != action) continue;
            return true;
        }
        return false;
    }

    public EffetPlusQuatre getEffetPlusQuatre() {
        for (Effet e : this.joueur.getEffets()) {
            if (!(e instanceof EffetPlusQuatre)) continue;
            return (EffetPlusQuatre)e;
        }
        return null;
    }
}

