/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.action.generateur;

import fr.utt.lo02.uno.base.Console;
import fr.utt.lo02.uno.jeu.action.ActionJoueur;
import fr.utt.lo02.uno.jeu.exception.ActionInvalideException;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import java.util.List;

public class GenerateurActionConsole
implements TourJoueurListener {
    private TourJoueur tour;

    public void action(String commande) {
        if (this.tour == null) {
            Console.getInstance().erreur("Ce n'est pas a vous de jouer");
        } else if (commande.isEmpty()) {
            this.afficheOptions();
        } else if (this.tour.getActions().getActionsPossibles().isEmpty()) {
            Console.getInstance().erreur("Vous ne pouvez faire aucune action");
        } else {
            try {
                this.tour.faireAction(Integer.valueOf(commande) - 1);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IndexOutOfBoundsException err) {
                Console.getInstance().erreur("Action invalide, entrez un chiffre compris entre 1 et " + this.tour.getActions().getActionsPossibles().size());
            }
            catch (ActionInvalideException err) {
                Console.getInstance().erreur(err.getMessage());
            }
        }
    }

    public void afficheOptions() {
        Console.getInstance().affiche("-----------------");
        Console.getInstance().affiche("Talon : " + this.tour.getActions().getPartie().getPlateau().getTalon().getCarte());
        Console.getInstance().affiche("Contenu de votre main : " + this.tour.getActions().getPartie().getJoueurs().getJoueur().getMain());
        Console.getInstance().affiche("Entrez le numero de l'action a effectuer : ");
        List<ActionJoueur> actions = this.tour.getActions().getActionsPossibles();
        int i = 0;
        while (i < actions.size()) {
            Console.getInstance().affiche(String.valueOf(i + 1) + ") " + actions.get(i));
            ++i;
        }
    }

    @Override
    public void debutTour(TourJoueur tour) {
        this.tour = tour;
        this.afficheOptions();
    }

    @Override
    public void finTour(TourJoueur tour) {
        this.tour = null;
    }

    @Override
    public void peutRejouer(TourJoueur tour) {
        this.afficheOptions();
    }
}

