/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.action.generateur;

import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import java.util.HashMap;
import java.util.Map;

public class VueJeu {
    private final Partie partie;
    private final Joueur joueur;

    public VueJeu(Joueur joueur, Partie partie) {
        this.joueur = joueur;
        this.partie = partie;
    }

    public VueJeu(TourJoueur tour) {
        this(tour.getActions().getPartie().getJoueurs().getJoueur(), tour.getActions().getPartie());
    }

    public Iterable<Carte> getCartes() {
        return this.joueur.getMain().getCartes();
    }

    public int getNombreCarteCouleur(Couleur couleur) {
        int nbr = 0;
        for (Carte c : this.getCartes()) {
            if (c.getCouleur() != couleur) continue;
            ++nbr;
        }
        return nbr;
    }

    public int getPointsCarteCouleur(Couleur couleur) {
        int pts = 0;
        for (Carte c : this.getCartes()) {
            if (c.getCouleur() != couleur) continue;
            pts += c.getValeurPoints();
        }
        return pts;
    }

    public Carte getCarteTalon() {
        return this.partie.getPlateau().getTalon().getCarte();
    }

    public Carte getAncienneCarteTalon() {
        return this.partie.getPlateau().getTalon().getCartePrecedente();
    }

    public int getNombreCartes() {
        return this.joueur.getMain().getCartes().size();
    }

    public Map<Joueur, Integer> getNombreCarteAutresJoueurs() {
        HashMap<Joueur, Integer> mains = new HashMap<Joueur, Integer>();
        Joueur[] joueurArray = this.partie.getJoueurs().getJoueurs();
        int n = joueurArray.length;
        int n2 = 0;
        while (n2 < n) {
            Joueur j = joueurArray[n2];
            if (j != this.joueur) {
                mains.put(j, j.getMain().getCartes().size());
            }
            ++n2;
        }
        return mains;
    }

    public int getNombreCarteJoueurPrecedent() {
        return this.partie.getJoueurs().getJoueurPrecedent().getMain().getCartes().size();
    }

    public int getNombreCarteJoueurSuivant() {
        return this.partie.getJoueurs().getJoueurSuivant().getMain().getCartes().size();
    }
}

