/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.action.generateur.ia;

import fr.utt.lo02.uno.jeu.action.ActionChoixCouleur;
import fr.utt.lo02.uno.jeu.action.ActionJoueur;
import fr.utt.lo02.uno.jeu.action.ActionPoseCarte;
import fr.utt.lo02.uno.jeu.action.generateur.VueJeu;
import fr.utt.lo02.uno.jeu.action.generateur.ia.AttributeurPoints;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.carte.TypeCarte;
import java.util.Random;

public class AnalyseurAction
implements AttributeurPoints {
    private static final int ACTION_FAIBLE = -1;
    private static final int ACTION_FORTE = 100;
    private final boolean fort;
    private final Random r;
    private int agressivite;

    public AnalyseurAction(boolean fort) {
        this.fort = fort;
        this.r = new Random();
    }

    @Override
    public int getPoints(ActionJoueur action, VueJeu vue) {
        switch (action.getType()) {
            case BLUFF: {
                Carte dessous = vue.getAncienneCarteTalon();
                if (this.fort && dessous.getCouleur() == vue.getCarteTalon().getCouleur()) {
                    return 50;
                }
                return this.agressivite / 3 * vue.getNombreCarteJoueurPrecedent();
            }
            case NON_BLUFF: {
                return 50 - this.r.nextInt(this.agressivite);
            }
            case CHOIX_COULEUR: {
                Couleur couleur = ((ActionChoixCouleur)action).getCouleur();
                return vue.getNombreCarteCouleur(couleur) == 0 ? -1 : vue.getPointsCarteCouleur(couleur);
            }
            case CONTRE_UNO: {
                return this.fort ? 100 : this.r.nextInt(50);
            }
            case UNO: {
                return this.fort ? 100 : this.r.nextInt(100);
            }
            case FIN_TOUR: {
                return this.fort ? -1 : this.r.nextInt(100);
            }
            case PIOCHE: {
                return -1;
            }
            case POSE: {
                Carte c = ((ActionPoseCarte)action).getCarte();
                if (c.getType() == TypeCarte.PLUS_QUATRE) {
                    return this.agressivite / (this.r.nextInt(10) + 2);
                }
                if (c.getType() == TypeCarte.JOKER) {
                    return 0;
                }
                return c.getValeurPoints() * vue.getNombreCarteCouleur(c.getCouleur()) + 1;
            }
        }
        return 0;
    }

    @Override
    public void nouvelleAction(VueJeu vue) {
        this.agressivite = 100 / Math.max(1, vue.getNombreCarteJoueurSuivant());
    }
}

