/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.action.generateur.ia;

import fr.utt.lo02.uno.jeu.action.generateur.Strategie;
import fr.utt.lo02.uno.jeu.action.generateur.VueJeu;
import fr.utt.lo02.uno.jeu.action.generateur.ia.StrategiePoints;
import fr.utt.lo02.uno.jeu.exception.ActionInvalideException;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import fr.utt.lo02.uno.temps.Evenement;
import fr.utt.lo02.uno.temps.Evenementiel;
import fr.utt.lo02.uno.temps.Periodique;

public class ComportementOrdinateur
implements TourJoueurListener,
Evenementiel {
    private final Periodique periodique;
    private final Strategie strategie;
    private TourJoueur tour;

    public ComportementOrdinateur(Periodique periodique, Strategie strategie) {
        this.periodique = periodique;
        this.strategie = strategie;
    }

    public ComportementOrdinateur(Periodique periodique) {
        this(periodique, new StrategiePoints());
    }

    public void joue(TourJoueur tour) {
        this.tour = tour;
        this.periodique.addEvenementFutur(new Evenement(1, this));
    }

    @Override
    public void debutTour(TourJoueur tour) {
        this.joue(tour);
    }

    @Override
    public void peutRejouer(TourJoueur tour) {
        this.joue(tour);
    }

    @Override
    public void finTour(TourJoueur tour) {
        tour = null;
    }

    @Override
    public void evenement(Periodique p) {
        if (this.tour != null) {
            try {
                this.tour.faireAction(this.strategie.getIDAction(this.tour.getActions().getActionsPossibles(), new VueJeu(this.tour.getActions().getPartie().getJoueurs().getJoueur(), this.tour.getActions().getPartie())));
            }
            catch (ActionInvalideException e) {
                e.printStackTrace();
            }
        }
    }
}

