/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.carte;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.interfaces.Sauvegardable;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.carte.CarteInversion;
import fr.utt.lo02.uno.jeu.carte.CarteJoker;
import fr.utt.lo02.uno.jeu.carte.CarteNumero;
import fr.utt.lo02.uno.jeu.carte.CartePasseTour;
import fr.utt.lo02.uno.jeu.carte.CartePlusDeux;
import fr.utt.lo02.uno.jeu.carte.CartePlusQuatre;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.carte.TypeCarte;

public abstract class Carte
implements Sauvegardable {
    protected Couleur couleur;

    public Carte() {
    }

    public Carte(Couleur couleur) {
        this.couleur = couleur;
    }

    public Carte(IO io) {
        this(Couleur.get(io.nextPositif()));
    }

    public abstract int getValeurPoints();

    public abstract void recouvrir();

    public abstract Carte dupliquer();

    public abstract TypeCarte getType();

    public abstract void faireEffet(Partie var1, boolean var2);

    public Couleur getCouleur() {
        return this.couleur;
    }

    public boolean estSymboleCompatible(Carte carte) {
        return carte.getType() == this.getType();
    }

    public boolean compatible(Carte carte) {
        return this.couleur == null || carte.couleur == null || carte.couleur == this.couleur || this.estSymboleCompatible(carte);
    }

    public int getValeurTri() {
        return this.couleur.ordinal() * 13;
    }

    public String toString() {
        return this.couleur.getNom();
    }

    @Override
    public IO sauvegarder(IO io) {
        return io.addBytePositif(this.getType().ordinal()).addBytePositif(this.couleur == null ? 255 : this.couleur.ordinal());
    }

    public static Carte getCarte(IO io) {
        switch (TypeCarte.values()[io.nextPositif()]) {
            case INVERSION: {
                return new CarteInversion(io);
            }
            case JOKER: {
                return new CarteJoker(io);
            }
            case NUMERO: {
                return new CarteNumero(io);
            }
            case PASSE_TOUR: {
                return new CartePasseTour(io);
            }
            case PLUS_DEUX: {
                return new CartePlusDeux(io);
            }
            case PLUS_QUATRE: {
                return new CartePlusQuatre(io);
            }
        }
        throw new IllegalArgumentException("Aucune carte ne peut etre lue");
    }
}

