/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.carte;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.CarteSimple;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.carte.TypeCarte;
import fr.utt.lo02.uno.jeu.effet.EffetPasseTour;
import fr.utt.lo02.uno.langue.Texte;

public class CarteInversion
extends CarteSimple {
    public CarteInversion(Couleur couleur) {
        super(couleur);
    }

    public CarteInversion(IO io) {
        super(io);
    }

    @Override
    public String toString() {
        return String.valueOf(Texte.get("Inversion")) + " " + super.toString();
    }

    @Override
    public int getValeurTri() {
        return super.getValeurTri() + 10;
    }

    @Override
    public int getValeurPoints() {
        return 20;
    }

    @Override
    public void faireEffet(Partie partie, boolean debutPartie) {
        if (partie.getJoueurs().getMaxJoueurs() == 2) {
            partie.getJoueurs().getJoueurSuivant().ajoutEffet(new EffetPasseTour());
        }
        partie.getJoueurs().inverseSens();
    }

    @Override
    public boolean estSymboleCompatible(Carte carte) {
        return carte instanceof CarteInversion;
    }

    @Override
    public CarteInversion dupliquer() {
        return new CarteInversion(this.couleur);
    }

    @Override
    public TypeCarte getType() {
        return TypeCarte.INVERSION;
    }
}

