/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.carte;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.CarteSimple;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.carte.TypeCarte;

public class CarteNumero
extends CarteSimple {
    public static final int MAXIMUM = 9;
    private final int numero;

    public CarteNumero(Couleur couleur, int numero) {
        super(couleur);
        this.numero = numero;
    }

    public CarteNumero(IO io) {
        super(io);
        this.numero = io.nextPositif();
    }

    public int getNumero() {
        return this.numero;
    }

    @Override
    public String toString() {
        return String.valueOf(this.numero) + " " + super.toString();
    }

    @Override
    public int getValeurTri() {
        return super.getValeurTri() + this.numero;
    }

    @Override
    public int getValeurPoints() {
        return this.numero;
    }

    @Override
    public void faireEffet(Partie partie, boolean debutPartie) {
    }

    @Override
    public boolean estSymboleCompatible(Carte carte) {
        return super.estSymboleCompatible(carte) && ((CarteNumero)carte).numero == this.numero;
    }

    @Override
    public CarteNumero dupliquer() {
        return new CarteNumero(this.couleur, this.numero);
    }

    @Override
    public IO sauvegarder(IO io) {
        return super.sauvegarder(io).addBytePositif(this.numero);
    }

    @Override
    public TypeCarte getType() {
        return TypeCarte.NUMERO;
    }
}

