/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.carte.ensemble;

import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import fr.utt.lo02.uno.jeu.listener.MainListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MainJoueur
extends Listenable
implements Comparator<Carte> {
    private final List<Carte> cartes;

    public MainJoueur() {
        this(new ArrayList<Carte>());
    }

    public MainJoueur(List<Carte> cartes) {
        this.cartes = cartes;
    }

    public List<Carte> getCartes() {
        return this.cartes;
    }

    public void ajoutCarte(Carte carte) {
        if (this.cartes.add(carte)) {
            Collections.sort(this.cartes, this);
            MainListener[] mainListenerArray = (MainListener[])this.getListeners(MainListener.class);
            int n = mainListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                MainListener l = mainListenerArray[n2];
                try {
                    l.ajoutCarte(carte, this.cartes.indexOf(carte));
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
                ++n2;
            }
        }
    }

    public Carte poseCarte(Carte carte) {
        int index = this.cartes.indexOf(carte);
        if (this.cartes.remove(carte)) {
            MainListener[] mainListenerArray = (MainListener[])this.getListeners(MainListener.class);
            int n = mainListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                MainListener l = mainListenerArray[n2];
                l.retireCarte(carte, index);
                ++n2;
            }
            return carte;
        }
        throw new IllegalArgumentException(this + " ne possede pas la carte " + carte);
    }

    public void vider() {
        while (!this.cartes.isEmpty()) {
            this.poseCarte(this.cartes.get(0));
        }
    }

    public boolean estVide() {
        return this.cartes.isEmpty();
    }

    public void addMainListener(MainListener l) {
        this.addListener(MainListener.class, l);
    }

    public void removeMainListener(MainListener l) {
        this.removeListener(MainListener.class, l);
    }

    public String toString() {
        if (this.cartes.isEmpty()) {
            return "(vide)";
        }
        String s = "";
        for (Carte c : this.cartes) {
            s = String.valueOf(s) + ", " + c;
        }
        return s.substring(2);
    }

    @Override
    public int compare(Carte o1, Carte o2) {
        return new Integer(o1.getValeurTri()).compareTo(o2.getValeurTri());
    }
}

