/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.carte.ensemble;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.interfaces.Sauvegardable;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.CarteInversion;
import fr.utt.lo02.uno.jeu.carte.CarteJoker;
import fr.utt.lo02.uno.jeu.carte.CarteNumero;
import fr.utt.lo02.uno.jeu.carte.CartePasseTour;
import fr.utt.lo02.uno.jeu.carte.CartePlusDeux;
import fr.utt.lo02.uno.jeu.carte.CartePlusQuatre;
import fr.utt.lo02.uno.jeu.carte.Couleur;
import fr.utt.lo02.uno.jeu.carte.ensemble.TasDeCarte;
import java.util.Stack;

public class PlateauJeu
implements Sauvegardable {
    private final TasDeCarte pioche;
    private final TasDeCarte talon;

    public PlateauJeu(Stack<Carte> cartes) {
        this.talon = new TasDeCarte();
        this.pioche = new TasDeCarte(cartes);
        this.pioche.melanger();
        this.talon.poser(this.pioche.piocher());
    }

    public PlateauJeu(IO io) {
        this.talon = new TasDeCarte(io);
        this.pioche = new TasDeCarte(io);
    }

    public PlateauJeu() {
        this(PlateauJeu.creerCartes());
    }

    public Carte piocher() {
        if (this.pioche.estVide()) {
            this.reconstruirePioche(this.talon.piocher());
        }
        return this.pioche.piocher();
    }

    public void reconstruirePioche(Carte carteTalon) {
        this.talon.transvaser(this.pioche);
        this.talon.poser(carteTalon);
    }

    public TasDeCarte getPioche() {
        return this.pioche;
    }

    public TasDeCarte getTalon() {
        return this.talon;
    }

    public String toString() {
        return "Talon : " + this.talon.getCarte() + " (" + this.pioche.getNombre() + " cartes dans la pioche)";
    }

    private static final Stack<Carte> creerCartes() {
        return PlateauJeu.creerCartes(2, 4, 4);
    }

    private static final Stack<Carte> creerCartes(int nbrMalus, int nbrJoker, int nbrPlus4) {
        Stack<Carte> cartes = new Stack<Carte>();
        Couleur[] couleurArray = Couleur.values();
        int n = couleurArray.length;
        int n2 = 0;
        while (n2 < n) {
            Couleur c = couleurArray[n2];
            int i = 0;
            while (i <= 9) {
                cartes.add(new CarteNumero(c, i));
                if (i != 0) {
                    cartes.add(new CarteNumero(c, i));
                }
                ++i;
            }
            i = 0;
            while (i < nbrMalus) {
                cartes.add(new CartePlusDeux(c));
                cartes.add(new CarteInversion(c));
                cartes.add(new CartePasseTour(c));
                ++i;
            }
            ++n2;
        }
        int i = 0;
        while (i < nbrJoker) {
            cartes.add(new CarteJoker());
            ++i;
        }
        i = 0;
        while (i < nbrPlus4) {
            cartes.add(new CartePlusQuatre());
            ++i;
        }
        return cartes;
    }

    @Override
    public IO sauvegarder(IO io) {
        return this.pioche.sauvegarder(this.talon.sauvegarder(io));
    }
}

