/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.carte.ensemble;

import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.interfaces.Sauvegardable;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import fr.utt.lo02.uno.jeu.listener.TasCarteListener;
import java.util.Collections;
import java.util.Stack;

public class TasDeCarte
extends Listenable
implements Sauvegardable {
    private final Stack<Carte> cartes;

    public TasDeCarte() {
        this(new Stack<Carte>());
    }

    public TasDeCarte(Stack<Carte> cartes) {
        this.cartes = cartes;
    }

    public TasDeCarte(IO io) {
        this();
        int nombre = io.nextPositif();
        int i = 0;
        while (i < nombre) {
            this.cartes.add(Carte.getCarte(io));
            ++i;
        }
    }

    public Carte getCarte() {
        if (this.cartes.isEmpty()) {
            return null;
        }
        return this.cartes.peek();
    }

    public void transvaser(TasDeCarte cible) {
        for (Carte c : this.cartes) {
            cible.cartes.add(c);
        }
        this.cartes.clear();
        cible.notifyTasCarteListener();
        this.notifyTasCarteListener();
    }

    public void melanger() {
        Collections.shuffle(this.cartes);
    }

    public Carte piocher() {
        Carte c = this.cartes.pop();
        this.notifyTasCarteListener();
        return c;
    }

    public Carte poser(Carte carte) {
        if (!this.cartes.isEmpty()) {
            this.cartes.peek().recouvrir();
        }
        this.cartes.push(carte);
        this.notifyTasCarteListener();
        return carte;
    }

    public boolean estVide() {
        return this.cartes.isEmpty();
    }

    public int getNombre() {
        return this.cartes.size();
    }

    public Carte getCartePrecedente() {
        return this.cartes.size() < 2 ? null : (Carte)this.cartes.get(this.cartes.size() - 2);
    }

    public void addTasCarteListener(TasCarteListener l) {
        this.addListener(TasCarteListener.class, l);
    }

    public void removeTasCarteListener(TasCarteListener l) {
        this.removeListener(TasCarteListener.class, l);
    }

    public void notifyTasCarteListener() {
        TasCarteListener[] tasCarteListenerArray = (TasCarteListener[])this.getListeners(TasCarteListener.class);
        int n = tasCarteListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TasCarteListener l = tasCarteListenerArray[n2];
            l.changeDessus(this.getCarte());
            ++n2;
        }
    }

    public String toString() {
        if (this.estVide()) {
            return "(vide)";
        }
        String s = "";
        for (Carte c : this.cartes) {
            s = String.valueOf(s) + ", " + c;
        }
        return s.substring(2);
    }

    @Override
    public IO sauvegarder(IO io) {
        io.addBytePositif(this.getNombre());
        for (Carte c : this.cartes) {
            c.sauvegarder(io);
        }
        return io;
    }
}

