/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.effet;

import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.carte.ensemble.MainJoueur;
import fr.utt.lo02.uno.jeu.effet.Effet;
import fr.utt.lo02.uno.langue.Texte;

public class EffetPioche
implements Effet {
    private int nombre;

    public EffetPioche(int nombre) {
        this.setNombre(nombre);
    }

    public void setNombre(int nombre) {
        if (nombre < 0) {
            throw new IllegalArgumentException("Le nombre de cartes a piocher doit etre positif");
        }
        this.nombre = nombre;
    }

    public void faireEffet(Partie partie, MainJoueur main) {
        int i = 0;
        while (i < this.nombre) {
            Carte carte = partie.getPlateau().piocher();
            main.ajoutCarte(carte);
            partie.notifyDeplacementCarte(partie.getPlateau().getPioche(), main, carte);
            ++i;
        }
    }

    @Override
    public boolean faireEffet(Partie partie, MainJoueur main, boolean finPartie) {
        this.faireEffet(partie, main);
        return true;
    }

    public String toString() {
        return String.valueOf(Texte.get("pioche")) + " " + this.nombre + " " + Texte.get("cartes");
    }

    @Override
    public int getPriorite() {
        return 2;
    }

    @Override
    public String getCheminImage() {
        return "pioche.png";
    }
}

