/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.joueur;

import fr.utt.lo02.uno.base.Console;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.action.ActionUno;
import fr.utt.lo02.uno.jeu.carte.ensemble.MainJoueur;
import fr.utt.lo02.uno.jeu.effet.Effet;
import fr.utt.lo02.uno.jeu.evenement.EvenementFinTour;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import fr.utt.lo02.uno.jeu.listener.EffetListener;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import fr.utt.lo02.uno.temps.Evenement;
import fr.utt.lo02.uno.ui.interfaces.ChangeTypeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Joueur
extends Listenable
implements Comparator<Effet> {
    private final List<Effet> effets;
    private final MainJoueur main;
    private Evenement evenement;
    private TypeJoueur type;
    private TourJoueur tour;
    private boolean uno;
    private String nom;

    public Joueur(TypeJoueur type, String nom, MainJoueur main) {
        this.type = type;
        this.nom = nom;
        this.main = main;
        this.effets = new ArrayList<Effet>();
    }

    public Joueur(TypeJoueur type, String nom) {
        this(type, nom, new MainJoueur());
    }

    public TourJoueur getTour() {
        return this.tour;
    }

    public TypeJoueur getType() {
        return this.type;
    }

    public MainJoueur getMain() {
        return this.main;
    }

    public void setType(TypeJoueur type) {
        this.type = type;
        ChangeTypeListener[] changeTypeListenerArray = (ChangeTypeListener[])this.getListeners(ChangeTypeListener.class);
        int n = changeTypeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeTypeListener l = changeTypeListenerArray[n2];
            l.changeType(type);
            ++n2;
        }
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void ajoutEffet(Effet effet) {
        Console.getInstance().affiche(this + " devra " + effet);
        this.effets.add(effet);
        Collections.sort(this.effets, this);
        EffetListener[] effetListenerArray = (EffetListener[])this.getListeners(EffetListener.class);
        int n = effetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            EffetListener l = effetListenerArray[n2];
            l.ajoutEffet(effet);
            ++n2;
        }
    }

    public boolean supprimeEffet(Effet effet) {
        boolean suppr = this.effets.remove(effet);
        if (suppr) {
            Console.getInstance().affiche(this + " ne devra plus " + effet);
            EffetListener[] effetListenerArray = (EffetListener[])this.getListeners(EffetListener.class);
            int n = effetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                EffetListener l = effetListenerArray[n2];
                l.retireEffet(effet);
                ++n2;
            }
        }
        return suppr;
    }

    public TourJoueur debutTour(Partie partie, int temps) {
        this.uno = false;
        Console.getInstance().retourLigne();
        Console.getInstance().affiche(this + " commence son tour");
        this.tour = new TourJoueur(this, partie);
        boolean uno = this.aDitUno();
        this.activeEffets(partie, false);
        if (this.tour != null && !this.tour.estTermine()) {
            this.evenement = new Evenement(temps, new EvenementFinTour(this.tour));
            partie.ajoutEvenement(this.evenement);
            TourJoueurListener[] tourJoueurListenerArray = (TourJoueurListener[])this.getListeners(TourJoueurListener.class);
            int n = tourJoueurListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                TourJoueurListener l = tourJoueurListenerArray[n2];
                l.debutTour(this.tour);
                ++n2;
            }
        } else if (uno) {
            this.ajoutEffet(new ActionUno());
        }
        return this.tour;
    }

    public void finTour() {
        if (this.evenement != null) {
            this.evenement.desactiver();
            this.tour.getActions().getPartie().getHorloge().removeEvenement(this.evenement);
        }
        this.uno = this.main.getCartes().size() == 1;
        Console.getInstance().affiche(this + " termine son tour");
        TourJoueurListener[] tourJoueurListenerArray = (TourJoueurListener[])this.getListeners(TourJoueurListener.class);
        int n = tourJoueurListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TourJoueurListener l = tourJoueurListenerArray[n2];
            l.finTour(this.tour);
            ++n2;
        }
        this.tour = null;
    }

    public void activeEffets(Partie partie, boolean finPartie) {
        int skip = 0;
        while (this.effets.size() > skip) {
            Effet e = this.effets.get(skip);
            try {
                Console.getInstance().affiche("(Effet sur" + this + ") : " + e);
                if (e.faireEffet(partie, this.main, finPartie)) {
                    this.supprimeEffet(e);
                    continue;
                }
                ++skip;
            }
            catch (Exception err) {
                Console.getInstance().erreur(this + " ne peut pas " + e);
                err.printStackTrace();
            }
        }
    }

    public void peutRejouer() {
        TourJoueurListener[] tourJoueurListenerArray = (TourJoueurListener[])this.getListeners(TourJoueurListener.class);
        int n = tourJoueurListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TourJoueurListener l = tourJoueurListenerArray[n2];
            l.peutRejouer(this.tour);
            ++n2;
        }
    }

    public String getNom() {
        return this.nom;
    }

    public boolean aDitUno() {
        for (Effet e : this.effets) {
            if (!(e instanceof ActionUno)) continue;
            return true;
        }
        return false;
    }

    public boolean estUno() {
        return this.uno;
    }

    public List<Effet> getEffets() {
        return this.effets;
    }

    public void addTourJoueurListener(TourJoueurListener l) {
        this.addListener(TourJoueurListener.class, l);
    }

    public void removeTourJoueurListener(TourJoueurListener l) {
        this.removeListener(TourJoueurListener.class, l);
    }

    public void addChangeTypeListener(ChangeTypeListener l) {
        this.addListener(ChangeTypeListener.class, l);
    }

    public void removeChangeTypeListener(ChangeTypeListener l) {
        this.removeListener(ChangeTypeListener.class, l);
    }

    public void addEffetListener(EffetListener l) {
        this.addListener(EffetListener.class, l);
    }

    public void removeEffetListener(EffetListener l) {
        this.removeListener(EffetListener.class, l);
    }

    public String toString() {
        return this.nom;
    }

    @Override
    public int compare(Effet e1, Effet e2) {
        return new Integer(e2.getPriorite()).compareTo(e1.getPriorite());
    }
}

