/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.joueur;

import fr.utt.lo02.uno.base.Console;
import fr.utt.lo02.uno.base.Generateur;
import fr.utt.lo02.uno.jeu.exception.JeuException;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TypeJoueur;
import fr.utt.lo02.uno.jeu.listener.ListeJoueurListener;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import java.util.ArrayList;
import java.util.List;

public class ListeJoueurs
extends Listenable {
    private final Joueur[] joueurs;
    private int indexJoueur;
    private boolean sens;

    public ListeJoueurs(int nombre) {
        if (nombre < 2) {
            throw new IllegalArgumentException("Cette liste doit comporter deux joueurs au minimum");
        }
        this.joueurs = new Joueur[nombre];
        this.sens = true;
    }

    public ListeJoueurs(Joueur ... joueurs) {
        this(joueurs.length);
        Joueur[] joueurArray = joueurs;
        int n = joueurs.length;
        int n2 = 0;
        while (n2 < n) {
            Joueur j = joueurArray[n2];
            try {
                this.ajoutJoueur(j);
            }
            catch (JeuException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void ajoutJoueur(Joueur joueur) throws JeuException {
        this.ajoutJoueur(this.getIDLibre(), joueur);
    }

    public void ajoutJoueur(int id, Joueur joueur) {
        if (this.joueurExiste(id)) {
            this.retireJoueur(id);
        }
        this.joueurs[id] = joueur;
        this.notifyAjoutJoueur(id, joueur);
        Console.getInstance().affiche(joueur + " rejoint la partie");
    }

    public boolean joueurExiste(int id) {
        return id >= 0 && id < this.joueurs.length && this.joueurs[id] != null;
    }

    public void retireJoueur(int id) {
        if (!this.joueurExiste(id)) {
            throw new IllegalArgumentException("Aucun joueur ne possede l'identifiant " + id);
        }
        Joueur j = this.joueurs[id];
        this.joueurs[id] = null;
        this.notifyRetireJoueur(id, j);
        Console.getInstance().affiche(j + " quitte la partie");
    }

    public void retireJoueur(Joueur joueur) {
        this.retireJoueur(this.getID(joueur));
    }

    public int getID(Joueur joueur) {
        int i = 0;
        while (i < this.joueurs.length) {
            if (this.joueurs[i] == joueur) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Ce joueur n'est pas present dans la liste");
    }

    public int getIDLibre() throws JeuException {
        int i = 0;
        while (i < this.joueurs.length) {
            if (!this.joueurExiste(i)) {
                return i;
            }
            ++i;
        }
        throw new JeuException("Cette liste est pleine");
    }

    public void inverseSens() {
        this.sens = !this.sens;
        Console.getInstance().affiche("Changement du sens de jeu");
    }

    public Joueur suivant() {
        this.indexJoueur += this.getIncrementJoueurSuivant();
        Console.getInstance().affiche("C'est au tour de " + this.getJoueur() + " de jouer");
        return this.getJoueur();
    }

    public Joueur precedent() {
        this.setIndexJoueur(this.getIndexJoueurPrecedent());
        return this.getJoueur();
    }

    public Joueur getJoueur(int id) {
        if (this.joueurExiste(id)) {
            return this.joueurs[id];
        }
        return null;
    }

    public Joueur getJoueur() {
        return this.joueurs[this.getIDJoueur()];
    }

    public Joueur getJoueurSuivant() {
        return this.joueurs[this.getIndexJoueurSuivant()];
    }

    public Joueur getJoueurPrecedent() {
        return this.joueurs[this.getIndexJoueurPrecedent()];
    }

    public int getIDJoueur() {
        while (this.indexJoueur < 0) {
            this.indexJoueur += this.joueurs.length;
        }
        return this.indexJoueur % this.joueurs.length;
    }

    public int getIndexJoueur() {
        while (this.indexJoueur < 0) {
            this.indexJoueur += this.joueurs.length;
        }
        return this.indexJoueur % this.joueurs.length;
    }

    public void setIndexJoueur(int indexJoueur) {
        this.indexJoueur = indexJoueur % this.joueurs.length;
        while (indexJoueur < 0) {
            indexJoueur += this.joueurs.length;
        }
    }

    public int getIndexJoueurSuivant() {
        int i = this.indexJoueur + this.getIncrementJoueurSuivant();
        while (i < 0) {
            i += this.joueurs.length;
        }
        return i % this.joueurs.length;
    }

    public int getIndexJoueurPrecedent() {
        int i = this.indexJoueur - this.getIncrementJoueurSuivant();
        while (i < 0) {
            i += this.joueurs.length;
        }
        return i % this.joueurs.length;
    }

    public Joueur[] getJoueurs() {
        return this.joueurs;
    }

    public List<Joueur> getListeJoueurs() {
        ArrayList<Joueur> l = new ArrayList<Joueur>();
        Joueur[] joueurArray = this.joueurs;
        int n = this.joueurs.length;
        int n2 = 0;
        while (n2 < n) {
            Joueur j = joueurArray[n2];
            if (j != null) {
                l.add(j);
            }
            ++n2;
        }
        return l;
    }

    public int getNombre() {
        int n = 0;
        Joueur[] joueurArray = this.joueurs;
        int n2 = this.joueurs.length;
        int n3 = 0;
        while (n3 < n2) {
            Joueur j = joueurArray[n3];
            if (j != null) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public int getMaxJoueurs() {
        return this.joueurs.length;
    }

    public void combler() {
        int i = 0;
        while (i < this.joueurs.length) {
            if (!this.joueurExiste(i)) {
                this.ajoutJoueur(i, new Joueur(TypeJoueur.ORDINATEUR, Generateur.getInstance().getNom()));
            }
            ++i;
        }
    }

    public void addListeJoueursListener(ListeJoueurListener l) {
        this.addListener(ListeJoueurListener.class, l);
    }

    public void removeListeJoueursListener(ListeJoueurListener l) {
        this.removeListener(ListeJoueurListener.class, l);
    }

    private void notifyAjoutJoueur(int id, Joueur joueur) {
        ListeJoueurListener[] listeJoueurListenerArray = (ListeJoueurListener[])this.getListeners(ListeJoueurListener.class);
        int n = listeJoueurListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListeJoueurListener l = listeJoueurListenerArray[n2];
            l.ajout(id, joueur);
            ++n2;
        }
    }

    private void notifyRetireJoueur(int id, Joueur joueur) {
        ListeJoueurListener[] listeJoueurListenerArray = (ListeJoueurListener[])this.getListeners(ListeJoueurListener.class);
        int n = listeJoueurListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListeJoueurListener l = listeJoueurListenerArray[n2];
            l.retire(id, joueur);
            ++n2;
        }
    }

    private int getIncrementJoueurSuivant() {
        return this.sens ? 1 : -1;
    }

    public boolean estPleine() {
        return this.getNombre() == this.getMaxJoueurs();
    }

    public boolean sensTrigo() {
        return this.sens;
    }

    public boolean aHumain() {
        Joueur[] joueurArray = this.joueurs;
        int n = this.joueurs.length;
        int n2 = 0;
        while (n2 < n) {
            Joueur j = joueurArray[n2];
            if (j != null && j.getType() != TypeJoueur.ORDINATEUR) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

