/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.joueur;

import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.action.ActionJoueur;
import fr.utt.lo02.uno.jeu.action.AutomateActions;
import fr.utt.lo02.uno.jeu.exception.ActionInvalideException;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.listener.ActionTourListener;
import fr.utt.lo02.uno.jeu.listener.Listenable;

public class TourJoueur
extends Listenable {
    private final AutomateActions actions;

    public TourJoueur(Joueur joueur, Partie partie) {
        this.actions = new AutomateActions(joueur, partie);
    }

    public AutomateActions getActions() {
        return this.actions;
    }

    public boolean faireAction(int idAction) throws ActionInvalideException {
        ActionJoueur action = this.actions.getActionsPossibles().get(idAction);
        this.actions.testeAction(action);
        action.faireEffet(this.actions.getPartie());
        this.actions.ajouteAction(action);
        ActionTourListener[] actionTourListenerArray = (ActionTourListener[])this.getListeners(ActionTourListener.class);
        int n = actionTourListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionTourListener l = actionTourListenerArray[n2];
            l.action(idAction, action);
            ++n2;
        }
        if (this.actions.estFini()) {
            this.actions.getPartie().finTour();
            return false;
        }
        this.actions.getJoueur().peutRejouer();
        return true;
    }

    public void termineTour() {
        try {
            while (!this.actions.estFini()) {
                this.faireAction(0);
            }
        }
        catch (ActionInvalideException e) {
            e.printStackTrace();
        }
    }

    public boolean estTermine() {
        return this.actions.estFini() || !this.actions.estTour();
    }

    public void addActionTourListener(ActionTourListener l) {
        this.addListener(ActionTourListener.class, l);
    }

    public void removeActionTourListener(ActionTourListener l) {
        this.removeListener(ActionTourListener.class, l);
    }

    public String toString() {
        return "Tour de jeu de " + this.actions.getJoueur();
    }
}

