/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.variantes;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.exception.InvalideException;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.ListeJoueurs;
import fr.utt.lo02.uno.jeu.variantes.TypeJeu;
import java.util.ArrayList;
import java.util.Map;

public class JeuChallenge
extends Jeu {
    public JeuChallenge(int nombre) {
        super(TypeJeu.CHALLENGE, nombre);
    }

    public ListeJoueurs getSurvivants() throws InvalideException {
        if (this.getResultats().isEmpty()) {
            return this.getListeJoueurs();
        }
        Map<Joueur, Integer> r = ResultatPartie.getPoints(this.getResultats());
        ArrayList<Joueur> survivants = new ArrayList<Joueur>();
        for (Map.Entry<Joueur, Integer> e : r.entrySet()) {
            if (e.getValue() >= Configuration.SCORE_DEFAITE) continue;
            survivants.add(e.getKey());
        }
        if (survivants.size() < 2) {
            throw new InvalideException("Il ne reste plus qu'un survivant");
        }
        return new ListeJoueurs(survivants.toArray(new Joueur[survivants.size()]));
    }

    @Override
    public Partie creerPartie() {
        try {
            return new Partie(this.getSurvivants());
        }
        catch (InvalideException e) {
            e.printStackTrace();
            return new Partie(this.getListeJoueurs());
        }
    }

    @Override
    public boolean estJeuFini() {
        try {
            this.getSurvivants();
            return false;
        }
        catch (InvalideException e) {
            return true;
        }
    }
}

