/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.variantes;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.variantes.TypeJeu;
import fr.utt.lo02.uno.langue.Texte;
import java.util.Map;

public class JeuEquipes
extends Jeu {
    public static final int NOMBRE_EQUIPES = 2;

    public JeuEquipes(int nombre) {
        super(TypeJeu.EQUIPES, nombre);
    }

    public int getEquipe(Joueur joueur) {
        return this.getListeJoueurs().getID(joueur) % 2;
    }

    public int getPoints(int equipe) {
        int pts = 0;
        for (Map.Entry<Joueur, Integer> e : ResultatPartie.getPoints(this.getResultats()).entrySet()) {
            if (this.getEquipe(e.getKey()) != equipe) continue;
            pts += e.getValue().intValue();
        }
        return pts;
    }

    public int[] getPoints() {
        int[] points = new int[2];
        int i = 0;
        while (i < points.length) {
            points[i] = this.getPoints(i);
            ++i;
        }
        return points;
    }

    @Override
    public String getGagnant() {
        int[] points = this.getPoints();
        int gagnant = -1;
        int pts = Configuration.SCORE_DEFAITE;
        int equipe = 0;
        while (equipe < points.length) {
            if (gagnant == -1 || points[equipe] < pts) {
                gagnant = equipe;
                pts = points[equipe];
            }
            ++equipe;
        }
        return String.valueOf(Texte.get("L'equipe")) + " " + (gagnant + 1) + " " + Texte.get("gagne le jeu avec") + " " + pts + " " + Texte.get("points") + " !";
    }

    @Override
    public boolean estJeuFini() {
        int[] nArray = this.getPoints();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i >= Configuration.SCORE_DEFAITE) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

