/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.jeu.variantes;

import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.variantes.JeuChallenge;
import fr.utt.lo02.uno.jeu.variantes.JeuEquipes;
import fr.utt.lo02.uno.langue.Texte;

public enum TypeJeu {
    CLASSIQUE,
    DUEL,
    EQUIPES,
    CHALLENGE;


    public String getNom() {
        return String.valueOf(this.toString().charAt(0)) + this.toString().substring(1).replace("_", " ").toLowerCase();
    }

    public Jeu creerJeu(int nombreJoueursAdmissibles) {
        switch (this) {
            case DUEL: {
                return new Jeu(2);
            }
            case CLASSIQUE: {
                return new Jeu(nombreJoueursAdmissibles);
            }
            case CHALLENGE: {
                return new JeuChallenge(nombreJoueursAdmissibles);
            }
            case EQUIPES: {
                return new JeuEquipes(nombreJoueursAdmissibles);
            }
        }
        throw new IllegalAccessError("Ce type de jeu n'a pas ete implemente");
    }

    public String getCheminDoc() {
        return this.getNom();
    }

    public static String[] getNoms() {
        String[] noms = new String[TypeJeu.values().length];
        int i = 0;
        while (i < noms.length) {
            noms[i] = Texte.get(TypeJeu.values()[i].getNom());
            ++i;
        }
        return noms;
    }
}

