/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.langue;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.Fichiers;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import fr.utt.lo02.uno.langue.Langue;
import fr.utt.lo02.uno.langue.LangueListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class Texte
extends Listenable {
    private static final String PATH = "textes.csv";
    private static final String SEPARATEUR = ";";
    private static Texte instance;
    private final Map<String, String[]> textes = new HashMap<String, String[]>();
    private Langue langue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texte getInstance() {
        Class<Texte> clazz = Texte.class;
        synchronized (Texte.class) {
            if (instance == null) {
                instance = new Texte();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Texte() {
        for (String s : Fichiers.getInstance().lireLignesFichier(PATH)) {
            String[] txt;
            if (s.startsWith("//") || s.isEmpty() || (txt = s.split(SEPARATEUR)).length <= 0) continue;
            this.textes.put(txt[0], txt);
        }
        this.langue = Configuration.LANGUE;
    }

    public void setLangue(Langue langue) {
        this.langue = langue;
        LangueListener[] langueListenerArray = (LangueListener[])this.getListeners(LangueListener.class);
        int n = langueListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LangueListener l = langueListenerArray[n2];
            l.changeLangue(langue);
            ++n2;
        }
    }

    public Langue getLangue() {
        return this.langue;
    }

    public String[] getTextes(String texte) {
        return this.textes.get(texte);
    }

    public String getTexte(String texte) {
        String[] textes = this.getTextes(texte);
        int l = this.langue.ordinal();
        if (textes != null && l < textes.length) {
            return textes[l];
        }
        System.err.println(String.valueOf(texte) + " n'a pas de correspondance en " + (Object)((Object)this.langue));
        return texte;
    }

    public void addLangueListener(LangueListener l) {
        this.addListener(LangueListener.class, l);
    }

    public void removeLangueListener(LangueListener l) {
        this.removeListener(LangueListener.class, l);
    }

    public boolean proposeChangeLangue() {
        int index = JOptionPane.showOptionDialog(null, null, Texte.get("Choisir une langue"), -1, -1, null, Langue.getNoms(), Texte.getInstance().getLangue().getNom());
        if (index == -1) {
            return false;
        }
        this.setLangue(Langue.values()[index]);
        return true;
    }

    public static String get(String texte) {
        return Texte.getInstance().getTexte(texte);
    }
}

