/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.temps;

import fr.utt.lo02.uno.base.Outil;
import fr.utt.lo02.uno.jeu.listener.Listenable;
import fr.utt.lo02.uno.temps.EvenementFutur;
import fr.utt.lo02.uno.temps.EvenementTempsDonne;
import fr.utt.lo02.uno.temps.PeriodiqueListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Periodique
extends Listenable
implements Runnable,
Comparator<EvenementTempsDonne> {
    private final List<EvenementTempsDonne> evenements;
    private final int delai;
    private long lancement;
    private int iterations;
    private boolean run;

    public Periodique(int delai) {
        this.delai = delai;
        this.evenements = new ArrayList<EvenementTempsDonne>();
    }

    public List<EvenementTempsDonne> getEvenements() {
        return this.evenements;
    }

    public void addEvenementFutur(EvenementFutur e) {
        e.setTemps(e.getTemps() + this.getIterations());
        this.addEvenementTempsDonne(e);
    }

    public void addEvenementTempsDonne(EvenementTempsDonne e) {
        if (e.getTemps() > this.getIterations()) {
            this.evenements.add(e);
            Collections.sort(this.evenements, this);
        } else {
            e.evenement(this);
        }
    }

    public boolean removeEvenement(EvenementTempsDonne e) {
        return this.evenements.remove(e);
    }

    public int getIterations() {
        return this.iterations;
    }

    public boolean enExecution() {
        return this.run;
    }

    public int getDecalage() {
        return (int)(this.getMilisecondeEcoule() - (long)this.getTempsTheorique());
    }

    public long getMilisecondeEcoule() {
        return System.currentTimeMillis() - this.lancement;
    }

    public int getTempsTheorique() {
        return this.iterations * this.delai;
    }

    public void setLancement() {
        this.lancement = System.currentTimeMillis();
        this.iterations = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvenements() {
        List<EvenementTempsDonne> list = this.evenements;
        synchronized (list) {
            EvenementTempsDonne e;
            while (!this.evenements.isEmpty() && (e = this.evenements.get(0)).getTemps() <= this.getIterations()) {
                if (this.evenements.remove(0) == null) continue;
                e.evenement(this);
            }
        }
    }

    public boolean terminer() {
        if (this.run) {
            this.run = false;
            return true;
        }
        return false;
    }

    public boolean lancer() {
        this.setLancement();
        if (this.run) {
            return false;
        }
        this.run = true;
        new Thread(this).start();
        return true;
    }

    public void addPeriodiqueListener(PeriodiqueListener l) {
        this.addListener(PeriodiqueListener.class, l);
    }

    public void removePeriodiqueListener(PeriodiqueListener l) {
        this.removeListener(PeriodiqueListener.class, l);
    }

    @Override
    public void run() {
        while (this.run) {
            Outil.attendre(Math.max(0, this.delai - this.getDecalage()));
            ++this.iterations;
            this.notifyEvenements();
            PeriodiqueListener[] periodiqueListenerArray = (PeriodiqueListener[])this.getListeners(PeriodiqueListener.class);
            int n = periodiqueListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PeriodiqueListener l = periodiqueListenerArray[n2];
                l.action(this);
                ++n2;
            }
        }
    }

    @Override
    public int compare(EvenementTempsDonne e1, EvenementTempsDonne e2) {
        return new Integer(e1.getTemps()).compareTo(e2.getTemps());
    }
}

