/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant;

import java.awt.Dimension;

public class Taille {
    private final Dimension dimension;
    private int max = Integer.MAX_VALUE;
    private int min = 1;
    private double rapport;

    public Taille() {
        this.dimension = new Dimension(1, 1);
        this.setRapport(1.0);
    }

    public Taille(int largeur) {
        this();
        this.setLargeur(largeur);
    }

    public Taille(int largeur, int hauteur) {
        this(largeur, (double)hauteur / (double)largeur);
    }

    public Taille(int largeur, double rapport) {
        this.dimension = new Dimension();
        this.setRapport(rapport).setLargeur(largeur);
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public double getRapport() {
        return this.rapport;
    }

    public int getLargeur() {
        return this.dimension.width;
    }

    public int getHauteur() {
        return this.dimension.height;
    }

    public int getLargeurMax() {
        return this.max;
    }

    public int getHauteurMax() {
        return (int)((double)this.max * this.rapport);
    }

    public int getlargeurMin() {
        return this.min;
    }

    public int getHauteurMin() {
        return (int)((double)this.min * this.rapport);
    }

    public Taille agrandir(int incr) {
        return this.setLargeur(this.dimension.width + incr);
    }

    public Taille setRapport(double rapport) {
        this.rapport = rapport;
        return this;
    }

    public Taille forceLargeur(int largeur) {
        this.dimension.width = largeur;
        return this;
    }

    public Taille forceHauteur(int hauteur) {
        this.dimension.height = hauteur;
        return this;
    }

    public void setMax() {
        this.setLargeur(this.getLargeurMax());
    }

    public void setMin() {
        this.setLargeur(this.getlargeurMin());
    }

    public void changeBorne() {
        if (this.getLargeur() > this.getLargeurMax() / 2) {
            this.setMin();
        } else {
            this.setMax();
        }
    }

    public Taille setLargeur(int largeur) {
        int h = (int)((double)largeur * this.rapport);
        if (largeur <= this.getLargeurMax() && h <= this.getHauteurMax() && largeur >= this.getlargeurMin() && h >= this.getHauteurMin()) {
            this.dimension.width = largeur;
            this.dimension.height = h;
        }
        return this;
    }

    public Taille setHauteur(int hauteur) {
        int l = (int)((double)hauteur / this.rapport);
        if (hauteur <= this.getHauteurMax() && l <= this.getLargeurMax() && hauteur >= this.getHauteurMin() && l >= this.getlargeurMin()) {
            this.dimension.height = hauteur;
            this.dimension.width = l;
        }
        return this;
    }

    public Taille setLargeurMax(int max) {
        this.max = max;
        return this;
    }

    public Taille setLargeurMin(int min) {
        this.min = min;
        return this;
    }

    public String toString() {
        return String.valueOf(this.dimension.width) + "/" + this.getLargeurMax() + ", " + this.getHauteur() + "/" + this.getHauteurMax() + " (" + this.dimension.width * 100 / this.max + "%)";
    }
}

