/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.chat;

import fr.utt.lo02.uno.base.Outil;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.io.Sons;
import fr.utt.lo02.uno.io.interfaces.Fermable;
import fr.utt.lo02.uno.io.interfaces.Lancable;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.IconeTache;
import fr.utt.lo02.uno.ui.composant.Bouton;
import fr.utt.lo02.uno.ui.listener.MessageChatListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;

public class BoutonChat
extends Bouton
implements MessageChatListener,
Fermable,
Lancable,
Runnable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private int nombre;
    private int difference;
    private final Component actif;
    private boolean run;

    public BoutonChat(Component actif) {
        super(new ImageIcon(Images.getInstance().getImage("chat.png")));
        this.actif = actif;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actif.setBounds(this.getParent().getWidth() - 250, this.getParent().getHeight() / 2 - 100, 250, 200);
        this.actif.setVisible(!this.actif.isVisible());
        if (this.actif.isVisible()) {
            this.fermer();
        }
    }

    @Override
    public void nouveauMessage(Joueur joueur, String message, List<String> messages) {
        if (!this.actif.isVisible()) {
            IconeTache.getInstance().message(String.valueOf(joueur.getNom()) + " " + Texte.get("dit") + " : ", message, TrayIcon.MessageType.NONE);
            Sons.getInstance().jouer("kling.wav");
            this.difference = messages.size() - this.nombre;
            this.lancer();
            this.repaint();
        } else {
            this.nombre = messages.size();
        }
    }

    @Override
    public boolean fermer() {
        if (!this.run) {
            return false;
        }
        this.actif.setVisible(true);
        this.difference = 0;
        this.run = false;
        return true;
    }

    @Override
    public boolean lancer() {
        if (this.run) {
            return false;
        }
        this.run = true;
        new Thread(this).start();
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.actif.isVisible() && this.difference != 0) {
            String txt = String.valueOf(this.difference);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.YELLOW);
            g.fillRoundRect(this.getWidth() - 20, 0, 20, 20, 10, 10);
            g.setColor(Color.BLACK);
            g.drawString(txt, this.getWidth() - g.getFontMetrics().stringWidth(txt) / 2 - 10, 15);
        }
    }

    @Override
    public void run() {
        while (this.run) {
            this.setSurvol(!this.estSurvol());
            Outil.attendre(500);
        }
    }
}

