/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.chat;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.io.IO;
import fr.utt.lo02.uno.io.reseau.Paquet;
import fr.utt.lo02.uno.io.reseau.TypePaquet;
import fr.utt.lo02.uno.io.reseau.client.SalleReseau;
import fr.utt.lo02.uno.io.reseau.listeners.ReceiveListener;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.chat.PanelMessages;
import fr.utt.lo02.uno.ui.composant.ecran.Ecran;
import fr.utt.lo02.uno.ui.listener.MessageChatListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Chat
extends Ecran
implements ReceiveListener,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private final SalleReseau salle;
    private final PanelMessages msg;
    private final JSlider taille;
    private final JTextField txt;
    private final JLabel txttail;
    private final int id;

    public Chat(int id, Joueur joueur, SalleReseau salle) {
        this.id = id;
        this.salle = salle;
        this.setMax(true);
        this.setLayout(new BorderLayout());
        this.msg = new PanelMessages(joueur);
        this.txt = new JTextField();
        this.txttail = new JLabel();
        this.taille = new JSlider(1, 5, 30, 12);
        this.txt.addActionListener(this);
        this.taille.addChangeListener(this);
        this.txt.setFont(Configuration.POLICE);
        this.stateChanged(null);
        this.add((Component)this.txttail, "North");
        this.add((Component)this.taille, "West");
        this.add((Component)new JScrollPane(this.msg), "Center");
        this.add((Component)this.txt, "South");
        salle.getClient().addReceiveListener(this);
    }

    public void addMessageChatListener(MessageChatListener l) {
        this.listenerList.add(MessageChatListener.class, l);
    }

    public void removeMessageChatListener(MessageChatListener l) {
        this.listenerList.remove(MessageChatListener.class, l);
    }

    @Override
    public boolean fermer() {
        this.salle.getClient().removeReceiveListener(this);
        return true;
    }

    @Override
    public void recu(TypePaquet type, IO io) {
        if (type == TypePaquet.MESSAGE) {
            Joueur j = this.salle.getJeu().getListeJoueurs().getJoueur(io.nextPositif());
            String message = io.nextString();
            this.msg.nouveauMessage(j, message);
            MessageChatListener[] messageChatListenerArray = (MessageChatListener[])this.getListeners(MessageChatListener.class);
            int n = messageChatListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                MessageChatListener l = messageChatListenerArray[n2];
                l.nouveauMessage(j, message, this.msg.getMessages());
                ++n2;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.txt.getText().length() >= 65535) {
            JOptionPane.showMessageDialog(null, String.valueOf(Texte.get("Vous ne pouvez pas ecrire plus que")) + " " + 65535 + " " + Texte.get("caracteres"));
        } else {
            this.salle.getClient().write(new Paquet(TypePaquet.MESSAGE).addBytePositif(this.id).add(this.txt.getText()));
            this.txt.setText("");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.msg.setFont(Configuration.POLICE.deriveFont((float)this.taille.getValue()));
        this.txttail.setText("" + this.taille.getValue());
    }
}

