/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.ecran;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.base.Outil;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.langue.Langue;
import fr.utt.lo02.uno.langue.LangueListener;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.Bouton;
import fr.utt.lo02.uno.ui.composant.ecran.Ecran;
import fr.utt.lo02.uno.ui.composant.specialise.PanelAccueil;
import fr.utt.lo02.uno.ui.layout.LayoutCentre;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class EcranAccueil
extends Ecran
implements Runnable,
LangueListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final BufferedImage logo;
    private final PanelAccueil accueil;
    private final Bouton langue;
    private boolean run;
    private boolean suivant;
    private String texte;
    private int x;
    private int index;

    public EcranAccueil() {
        this.setMax(true);
        this.setImage(Images.getInstance().getImage("fond.jpg"));
        this.setName(Texte.get("Accueil"));
        this.logo = Images.getInstance().getImage("utt.png");
        this.langue = new Bouton(new ImageIcon(Images.getInstance().getImage(Texte.getInstance().getLangue().getCheminImage())));
        this.accueil = new PanelAccueil(this);
        this.setLayout(new LayoutCentre(){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                EcranAccueil.this.langue.setBounds(5, 5, 100, 75);
            }
        });
        this.add(this.langue);
        this.add(this.accueil);
        this.accueil.lancer();
        this.langue.setFond(false);
        this.langue.setToolTipText(Texte.get("Changer de langue"));
        this.langue.addActionListener(this);
        this.run = true;
        if (Configuration.MESSAGES.length > 0) {
            new Thread(this).start();
        }
        Texte.getInstance().addLangueListener(this);
    }

    @Override
    public boolean fermer() {
        this.accueil.terminer();
        this.run = false;
        Texte.getInstance().removeLangueListener(this);
        return super.fermer();
    }

    @Override
    public void run() {
        this.texte = Configuration.MESSAGES[this.index];
        while (this.run) {
            Outil.attendre(50);
            this.x += 2;
            if (this.suivant) {
                this.suivant = false;
                ++this.index;
                if (this.index >= Configuration.MESSAGES.length) {
                    this.index = 0;
                }
                this.texte = Configuration.MESSAGES[this.index];
                this.x = 0;
            }
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.texte != null) {
            g.setFont(Configuration.POLICE.deriveFont(2).deriveFont(12.0f));
            g.setColor(Color.YELLOW);
            int nx = this.x - g.getFontMetrics().stringWidth(this.texte);
            g.drawString(this.texte, nx, this.getHeight() - 5);
            if (nx > this.getWidth()) {
                this.suivant = true;
            }
        }
        g.drawImage(this.logo, this.getWidth() - this.logo.getWidth(), 0, null);
    }

    @Override
    public void changeLangue(Langue langue) {
        this.changeEcran(new EcranAccueil());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Texte.getInstance().proposeChangeLangue();
    }
}

