/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.ecran;

import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.jeu.Controleur;
import fr.utt.lo02.uno.jeu.Jeu;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.Salle;
import fr.utt.lo02.uno.jeu.carte.Carte;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.jeu.joueur.TourJoueur;
import fr.utt.lo02.uno.jeu.listener.DeplacementCarteListener;
import fr.utt.lo02.uno.jeu.listener.JeuListener;
import fr.utt.lo02.uno.jeu.listener.TourJoueurListener;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.IconeTache;
import fr.utt.lo02.uno.ui.composant.Bouton;
import fr.utt.lo02.uno.ui.composant.ecran.Ecran;
import fr.utt.lo02.uno.ui.composant.ecran.EcranResultatJeu;
import fr.utt.lo02.uno.ui.composant.ecran.EcranScores;
import fr.utt.lo02.uno.ui.composant.specialise.animation.AnimateurCarte;
import fr.utt.lo02.uno.ui.composant.specialise.animation.AnimationCarte;
import fr.utt.lo02.uno.ui.composant.specialise.animation.PanelAnimations;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.BarreTourJoueurs;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.MainJoueurGraphiqueVisible;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.PanelActionJoueur;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.PanelChoixCouleur;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.PanelJoueur;
import fr.utt.lo02.uno.ui.composant.specialise.jeu.PlateauGraphique;
import fr.utt.lo02.uno.ui.layout.LayoutCentre;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class EcranPartie
extends Ecran
implements LayoutManager,
JeuListener,
DeplacementCarteListener,
TourJoueurListener,
ActionListener {
    private static final Dimension TAILLE_PLATEAU = new Dimension(280, 190);
    private static final long serialVersionUID = 1L;
    private final MainJoueurGraphiqueVisible mainJoueur;
    private final PanelAnimations animations;
    private final PanelActionJoueur actions;
    private final PanelChoixCouleur couleur;
    private final List<PanelJoueur> joueurs;
    private final PlateauGraphique plateau;
    private final BarreTourJoueurs barre;
    private final BufferedImage contours;
    private final Controleur controleur;
    private final AbstractButton info;
    private final Partie partie;
    private final Joueur joueur;
    private final Salle salle;
    private JInternalFrame fenetre;

    public EcranPartie(Controleur controleur, Joueur joueur, Salle salle) {
        this.joueur = joueur;
        this.salle = salle;
        this.controleur = controleur;
        this.partie = salle.getJeu().getPartie();
        this.contours = Images.getInstance().getImage("contours.png");
        this.setImage(Images.getInstance().getImage("tapis 2.jpg"));
        this.setMax(true);
        this.setName(joueur.getNom());
        this.joueurs = new ArrayList<PanelJoueur>();
        this.animations = new PanelAnimations(salle);
        this.plateau = new PlateauGraphique(this.partie.getPlateau());
        this.mainJoueur = new MainJoueurGraphiqueVisible(controleur, joueur.getMain());
        this.barre = new BarreTourJoueurs(this.joueurs, this.partie.getJoueurs());
        this.couleur = new PanelChoixCouleur();
        this.actions = new PanelActionJoueur();
        this.info = new Bouton(new ImageIcon(Images.getInstance().getImage("info.png")));
        Joueur[] joueurArray = this.partie.getJoueurs().getJoueurs();
        int n = joueurArray.length;
        int n2 = 0;
        while (n2 < n) {
            Joueur j = joueurArray[n2];
            if (j != null) {
                this.ajoutJoueur(j);
            }
            ++n2;
        }
        this.plateau.getPioche().addPanelTasCarteListener(controleur);
        this.couleur.addChoixCouleurListener(controleur);
        this.actions.addPanelActionJoueurListener(controleur);
        this.info.addActionListener(this);
        joueur.addTourJoueurListener(this.mainJoueur);
        joueur.addTourJoueurListener(this.plateau.getPioche());
        joueur.addTourJoueurListener(this.couleur);
        joueur.addTourJoueurListener(this.actions);
        joueur.addTourJoueurListener(this);
        this.partie.getHorloge().addHorlogeListener(this.barre);
        this.partie.getPlateau().getTalon().addTasCarteListener(this.barre);
        this.partie.addDeplacementCarteListener(this);
        salle.getJeu().addJeuListener(this);
        this.mainJoueur.setSize(0, 175);
        this.setLayout(this);
        this.add(this.actions);
        this.add(this.couleur);
        this.add(this.animations);
        this.add(this.mainJoueur);
        this.add(this.plateau);
        this.add(this.barre);
        this.add(this.info);
        this.barre.lancer();
    }

    public void ajoutJoueur(Joueur j) {
        j.addTourJoueurListener(this.barre);
        j.addTourJoueurListener(this.animations);
        PanelJoueur pj = new PanelJoueur(j);
        if (j == this.joueur) {
            pj.add((Component)new JLabel(), "Center");
            pj.setImage(null);
        }
        this.joueurs.add(pj);
        this.add(pj);
    }

    public AnimateurCarte getAnimateur(Object o) {
        if (o == this.mainJoueur.getMain()) {
            return this.mainJoueur;
        }
        if (o == this.plateau.getPioche().getTas()) {
            return this.plateau.getPioche();
        }
        if (o == this.plateau.getTalon().getTas()) {
            return this.plateau.getTalon();
        }
        for (PanelJoueur pj : this.joueurs) {
            if (o != pj.getJoueur().getMain()) continue;
            return pj.getMain();
        }
        throw new IllegalArgumentException("Cet element originaire du modele n'est pas affiche par cette vue");
    }

    @Override
    public void deplacement(Object source, Object cible, Carte c) {
        if (this.isShowing()) {
            this.animations.nouvelleAnimation(new AnimationCarte(c, this.getAnimateur(source), this.getAnimateur(cible)));
        }
    }

    @Override
    public void finPartie(Partie partie, ResultatPartie resultats) {
        this.changeEcran(this.salle.getJeu().estJeuFini() ? new EcranResultatJeu(this.joueur, this.salle.getJeu()) : new EcranScores(this.joueur, this.controleur, this.salle));
    }

    @Override
    public void finJeu(List<ResultatPartie> resultats, Jeu jeu) {
    }

    @Override
    public boolean fermer() {
        this.barre.fermer();
        this.animations.fermer();
        this.salle.getJeu().removeJeuListener(this);
        this.partie.getHorloge().removeHorlogeListener(this.barre);
        for (Joueur j : this.partie.getJoueurs().getListeJoueurs()) {
            j.removeTourJoueurListener(this.barre);
            j.removeTourJoueurListener(this.animations);
        }
        this.joueur.removeTourJoueurListener(this);
        this.joueur.removeTourJoueurListener(this.mainJoueur);
        this.joueur.removeTourJoueurListener(this.plateau.getPioche());
        this.joueur.removeTourJoueurListener(this.couleur);
        this.joueur.removeTourJoueurListener(this.actions);
        return true;
    }

    @Override
    public void layoutContainer(Container parent) {
        this.plateau.setBounds((this.getWidth() - EcranPartie.TAILLE_PLATEAU.width) / 2, (this.getHeight() - EcranPartie.TAILLE_PLATEAU.height) / 2, EcranPartie.TAILLE_PLATEAU.width, EcranPartie.TAILLE_PLATEAU.height);
        Dimension d = this.mainJoueur.getPreferredSize();
        if ((double)d.width > (double)this.getWidth() / 1.5) {
            d.width = (int)((double)this.getWidth() / 1.5);
        }
        this.mainJoueur.setBounds((this.getWidth() - d.width) / 2, this.getHeight() - d.height, d.width, d.height);
        this.animations.setBounds(this.getBounds());
        int w = this.getWidth() / (this.joueurs.size() + 1);
        int h = this.getHeight() / 5;
        int dx = (this.getWidth() - this.joueurs.size() * w) / Math.max(1, this.joueurs.size() - 1);
        int i = 0;
        while (i < this.joueurs.size()) {
            this.joueurs.get(i).setBounds(i * (w + dx), 30, w, h);
            ++i;
        }
        this.barre.setBounds(0, 0, this.getWidth(), 30);
        LayoutCentre.setTaille(this, this.couleur, this.couleur.getPreferredSize().width, this.couleur.getPreferredSize().height);
        this.actions.setBounds(5, (this.getHeight() - this.actions.getHauteur()) / 2, 150, this.actions.getHauteur());
        this.info.setBounds(5, this.getHeight() - 55, 50, 50);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension();
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.contours, (this.getWidth() - this.contours.getWidth()) / 2, (this.getHeight() - this.contours.getHeight()) / 2, null);
    }

    @Override
    public void debutTour(TourJoueur tour) {
        if (!this.estAffiche()) {
            IconeTache.getInstance().message(this.joueur.getNom(), Texte.get("C'est votre tour de jouer"), TrayIcon.MessageType.NONE);
        }
        this.demandeFocus();
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.fenetre == null || !this.fenetre.isVisible()) {
            try {
                JEditorPane p = new JEditorPane(this.getClass().getResource("/" + this.salle.getJeu().getType().getCheminDoc() + ".html"));
                this.fenetre = new JInternalFrame(this.salle.getJeu().getType().getNom(), true, true, true);
                this.fenetre.setContentPane(new JScrollPane(p));
                this.fenetre.setBounds(5, this.getHeight() / 2 - 60, 250, this.getHeight() / 2);
                this.fenetre.setVisible(true);
                this.add((Component)this.fenetre, 0);
            }
            catch (IOException err) {
                err.printStackTrace();
            }
        } else {
            this.fenetre.setVisible(false);
            this.remove(this.fenetre);
            this.fenetre = null;
        }
    }

    @Override
    public void finTour(TourJoueur tour) {
        if (!this.estAffiche()) {
            IconeTache.getInstance().message(this.joueur.getNom(), Texte.get("Votre tour est fini"), TrayIcon.MessageType.NONE);
        }
    }

    @Override
    public void peutRejouer(TourJoueur tour) {
        if (!this.estAffiche()) {
            IconeTache.getInstance().message(this.joueur.getNom(), Texte.get("Vous pouvez rejouer"), TrayIcon.MessageType.NONE);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void nouvellePartie(Partie partie) {
    }
}

