/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.ecran;

import fr.utt.lo02.uno.io.reseau.client.ControleurPartieEnLigne;
import fr.utt.lo02.uno.io.reseau.client.SalleReseau;
import fr.utt.lo02.uno.jeu.Partie;
import fr.utt.lo02.uno.jeu.ResultatPartie;
import fr.utt.lo02.uno.jeu.joueur.Joueur;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.composant.chat.BoutonChat;
import fr.utt.lo02.uno.ui.composant.chat.Chat;
import fr.utt.lo02.uno.ui.composant.ecran.EcranPartie;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JInternalFrame;

public class EcranPartieReseau
extends EcranPartie {
    private static final long serialVersionUID = 1L;
    private final JInternalFrame fenetre;
    private final BoutonChat affiche;
    private final SalleReseau salle;
    private final Chat chat;

    public EcranPartieReseau(Joueur joueur, SalleReseau salle) {
        super(new ControleurPartieEnLigne(salle.getClient(), joueur), joueur, salle);
        this.salle = salle;
        this.chat = new Chat(salle.getJeu().getListeJoueurs().getID(joueur), joueur, salle);
        this.fenetre = new JInternalFrame(Texte.get("Chat"), true, true, true);
        this.affiche = new BoutonChat(this.fenetre);
        this.fenetre.setContentPane(this.chat);
        this.chat.addMessageChatListener(this.affiche);
        this.add((Component)this.affiche, 1);
        this.add((Component)this.fenetre, 0);
    }

    @Override
    public void layoutContainer(Container parent) {
        super.layoutContainer(parent);
        this.affiche.setBounds(this.getWidth() - 70, this.getHeight() - 70, 60, 60);
    }

    @Override
    public boolean fermer() {
        return this.chat.fermer();
    }

    @Override
    public void finPartie(Partie partie, ResultatPartie resultats) {
        super.finPartie(partie, resultats);
        if (this.salle.getJeu().estJeuFini()) {
            this.salle.getClient().fermer();
        }
    }
}

