/*
 * Decompiled with CFR 0.152.
 */
package fr.utt.lo02.uno.ui.composant.ecran;

import fr.utt.lo02.uno.base.Configuration;
import fr.utt.lo02.uno.base.Generateur;
import fr.utt.lo02.uno.io.Images;
import fr.utt.lo02.uno.io.reseau.InfoSalle;
import fr.utt.lo02.uno.io.reseau.client.RechercheLocale;
import fr.utt.lo02.uno.io.reseau.client.RechercheServeurs;
import fr.utt.lo02.uno.io.reseau.client.SalleReseau;
import fr.utt.lo02.uno.io.reseau.listeners.RechercheSalleListener;
import fr.utt.lo02.uno.langue.Texte;
import fr.utt.lo02.uno.ui.IconeTache;
import fr.utt.lo02.uno.ui.composant.Bouton;
import fr.utt.lo02.uno.ui.composant.PanelImage;
import fr.utt.lo02.uno.ui.composant.ecran.Ecran;
import fr.utt.lo02.uno.ui.composant.ecran.EcranAccueil;
import fr.utt.lo02.uno.ui.composant.ecran.EcranCreerSalle;
import fr.utt.lo02.uno.ui.composant.ecran.EcranSalleEnLigne;
import fr.utt.lo02.uno.ui.composant.specialise.ModeleSalles;
import fr.utt.lo02.uno.ui.composant.specialise.PanelAdresses;
import fr.utt.lo02.uno.ui.layout.LayoutCentre;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.InetAddress;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EcranRejoindreSalle
extends Ecran
implements RechercheSalleListener,
ActionListener,
KeyListener,
ListDataListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private final AbstractButton rejoindre;
    private final AbstractButton actualise;
    private final AbstractButton creer;
    private final AbstractButton retour;
    private final AbstractButton changeNom;
    private final PanelAdresses adresses;
    private final ModeleSalles modele;
    private final JScrollPane centre;
    private final JTextField nom;
    private final PanelImage bas;
    private final JList salles;
    private RechercheServeurs recherche;
    private RechercheLocale local;

    public EcranRejoindreSalle() {
        this.setLayout(new LayoutCentre(500, 500));
        this.setName(Texte.get("Rejoindre une salle"));
        this.setImage(Images.getInstance().getImage("fond.jpg"));
        this.setMax(true);
        try {
            this.local = new RechercheLocale();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PanelImage p = new PanelImage(new BorderLayout(5, 5));
        this.adresses = new PanelAdresses();
        this.nom = new JTextField(Generateur.getInstance().getNomPrincipal());
        this.nom.setFont(Configuration.POLICE);
        this.changeNom = new Bouton(new ImageIcon(Images.getInstance().getImage("random.png")));
        PanelImage haut = new PanelImage(new BorderLayout(5, 5));
        haut.setMax(true);
        haut.setImage(Images.getInstance().getImage("fond transparent.png"));
        JLabel txt = new JLabel("   " + Texte.get("Votre nom") + " : ", 0);
        txt.setForeground(Color.WHITE);
        txt.setFont(Configuration.POLICE);
        haut.add((Component)txt, "West");
        haut.add((Component)this.changeNom, "East");
        haut.add(Box.createRigidArea(new Dimension(5, 5)), "North");
        haut.add(Box.createRigidArea(new Dimension(5, 5)), "South");
        haut.add((Component)this.nom, "Center");
        this.modele = new ModeleSalles();
        this.salles = new JList(this.modele);
        this.salles.setBackground(new Color(150, 175, 255));
        this.salles.addListSelectionListener(this);
        this.salles.setFont(Configuration.POLICE);
        this.centre = new JScrollPane(this.salles);
        this.centre.setBorder(null);
        this.centre.getViewport().setOpaque(false);
        this.bas = new PanelImage(new FlowLayout());
        this.retour = new Bouton(Texte.get("Retour"), new ImageIcon(Images.getInstance().getImage("retour.png").getScaledInstance(16, 16, 16)));
        this.bas.add(this.retour);
        this.rejoindre = new Bouton(Texte.get("Rejoindre"));
        this.bas.add((Component)this.rejoindre, new ImageIcon(Images.getInstance().getImage("ok.png").getScaledInstance(16, 16, 16)));
        this.actualise = new Bouton(Texte.get("Rafraichir"), new ImageIcon(Images.getInstance().getImage("online.png").getScaledInstance(16, 16, 16)));
        this.bas.add(this.actualise);
        this.creer = new Bouton(Texte.get("Creer une salle"));
        this.bas.add(this.creer);
        this.retour.addActionListener(this);
        this.rejoindre.addActionListener(this);
        this.actualise.addActionListener(this);
        this.creer.addActionListener(this);
        this.changeNom.addActionListener(this);
        this.adresses.addListener(this);
        this.rejoindre.setEnabled(false);
        p.add((Component)haut, "North");
        p.add((Component)this.centre, "Center");
        p.add((Component)this.bas, "South");
        p.add((Component)this.adresses, "West");
        this.add(p);
        this.nom.addKeyListener(this);
        this.salles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    EcranRejoindreSalle.this.connecte();
                }
            }
        });
        if (this.local != null) {
            try {
                this.local.lancer();
                this.local.addRechercheSalleListener(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.recherche();
    }

    public void recherche() {
        this.rejoindre.setEnabled(false);
        if (this.recherche != null) {
            this.recherche.removeRechercheSalleListener(this);
            this.recherche.terminer();
        }
        this.modele.clear();
        this.recherche = new RechercheServeurs(this.adresses.getAdresses());
        this.recherche.addRechercheSalleListener(this);
        this.local.demandeInfos();
        this.recherche.lancer();
    }

    public void connecte() {
        try {
            this.changeEcran(new EcranSalleEnLigne(new SalleReseau(this.nom.getText(), ((InfoSalle)this.salles.getSelectedValue()).getAdresse())));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Texte.get("Cette partie n'est plus disponible"));
            this.recherche();
        }
    }

    public void setAffiche(boolean affiche) {
        this.centre.setVisible(affiche);
        this.rejoindre.setVisible(affiche);
        this.actualise.setVisible(affiche);
        this.adresses.setVisible(affiche);
        this.validate();
        this.repaint();
    }

    public void changeNom() {
        this.setAffiche(this.nom.getText() != null && !this.nom.getText().isEmpty());
    }

    @Override
    public boolean fermer() {
        if (this.local != null) {
            this.local.removeRechercheSalleListener(this);
            this.local.fermer();
        }
        if (this.recherche != null) {
            this.recherche.removeRechercheSalleListener(this);
            this.recherche.terminer();
        }
        return super.fermer();
    }

    @Override
    public void nouvelleSalle(InetAddress adresse, InfoSalle infos) {
        infos.setAdresse(adresse);
        this.modele.add(infos);
        if (!this.estAffiche()) {
            IconeTache.getInstance().message(Texte.get("Salle de jeu trouv\u00e9e"), String.valueOf(infos.getNom()) + " (" + infos.getNombreJoueursMax() + " " + Texte.get("joueurs") + ") : " + adresse, TrayIcon.MessageType.NONE);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.retour) {
            this.changeEcran(new EcranAccueil());
        } else if (e.getSource() == this.actualise) {
            this.recherche();
        } else if (e.getSource() == this.rejoindre) {
            this.connecte();
        } else if (e.getSource() == this.creer) {
            this.changeEcran(new EcranCreerSalle(true));
        } else if (e.getSource() == this.changeNom) {
            this.changeNom();
            this.nom.setText(Generateur.getInstance().setNomPrincipal(Generateur.getInstance().getNom()));
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.recherche();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Generateur.getInstance().setNomPrincipal(this.nom.getText());
        this.changeNom();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.rejoindre.setEnabled(this.salles.getSelectedIndex() != -1);
    }
}

